/**	
 *  @file	RFPPack.cpp
 *  @brief	Implementation of class CRFPPack class
 *
 *	
 */

#include	<stdio.h>
#include	<string.h>
#include	<assert.h>
#include	"pp/RFPPack.h"
#include	"pp/SIO.h"

using namespace pp;

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Forward References
 *--------------------------------------*/

/*----------------------------------------
 *	Code
 *--------------------------------------*/

/*  --------------------------------------------------------------------*/
int main( int argc, char *argv[] )
{
	char	*	pHeaderFileName = "rfp.xml";
	char		outFileName[128] = "out.rfp";
	int			x;
	int			length;
	int			result;
	
	// ----------------------------------------
	// Parse the command line
	
	if (argc < 2)
		pHeaderFileName = "testrfp.xml";
	else
		pHeaderFileName = &argv[1][0];

	if (argc > 2)
	{
		strcpy(outFileName,argv[2]);
	}
	else
	{
		length = strlen(pHeaderFileName);

		for (x=0;x<length;x++)
		{
			if (pHeaderFileName[x] == '.')
				break;

			outFileName[x] = pHeaderFileName[x];
		}

		outFileName[x] = 0;
		strcat(outFileName,".rfp");
	}

	// ----------------------------------------
	// Pack the RFP

	CRFPPack	rfp;
	RFP_FILE	*pRFP_File;
	CSIO_FP		sioHeader;
	CSIO_FP		sioOutput;

	rfp.SetCopyUnknownTagsOption( 1 );
 
	result = sioHeader.Open(pHeaderFileName,"rb");
	if (result < 0)
	{
		printf("Cannot open header file %s\n",pHeaderFileName);
		return -1;
	}

	result = sioOutput.Open(outFileName,"wb");
	if (result < 0)
	{
		printf("Cannot open output file %s\n",outFileName);
		return -1;
	}

	result = rfp.CreateSchema( &sioHeader );
	if (result != 0)
	{
		printf("Error while parsing header file %s\n",pHeaderFileName);
		goto ERROR;
	}

	result = rfp.PackRFP( &sioOutput );
	if (result != 0)
	{
		printf("Error while packing RFP\n");
		goto ERROR;
	}

	// ----------------------------------------
	// Show error code

ERROR:

	switch (result)
	{
		case 0:
			break;

		case RFP_ERROR_TOO_MANY_FILES:
			printf("More files in header than appended to file.\n");
			break;

		case RFP_ERROR_MAXLENGTH_NOT_LAST:
			printf("Either file is longer than max length or max length used more than once\n");
			break;

		case RFP_ERROR_NO_LENGTH:
			printf("No length specified.\n");
			break;

		case RFP_ERROR_RSA_KEY_MISSING:
			pRFP_File = rfp.EnumFile( rfp.GetErrorFile() );
            if (pRFP_File == NULL)
				printf("Cannot open RSA file %s for the header.\n",rfp.GetHeader()->rsaKeyFile);
			else
                printf("Cannot open RSA file %s for file %s.\n",pRFP_File->rsaKeyFile,pRFP_File->fileName);
			break;

		case RFP_ERROR_RC4_KEY_MISSING:
			pRFP_File = rfp.EnumFile( rfp.GetErrorFile() );
            if (pRFP_File == NULL)
				printf("Huh??? RFP_ERROR_RC4_KEY_MISSING for Header!!!.\n");
			else
                printf("Cannot open RC4 file %s for file %s.\n",pRFP_File->rc4KeyFile,pRFP_File->fileName);
			break;

		case RFP_ERROR_CANNOT_READ_FILE:
			pRFP_File = rfp.EnumFile( rfp.GetErrorFile() );
            if (pRFP_File == NULL)
				printf("Cannot open file %s\n",pRFP_File->fileName);
			else
				printf("Cannot open file ???\n");
			break;

		default:
			if (result<0)
				printf("XML parse error (%d)\n",result);
			else
				printf("Unknown error %d\n",result);
			break;
	}

	return result;
}

