/*--------------------------------------------------------------------------------

	SIO.h

	Copyright (c) 2002, Raritan Computer, Inc.

	Header file for CSIO, CSIO_FP, CSIO_SMEM, CSIO_DMEM

--------------------------------------------------------------------------------*/

#ifndef _SIO_H_
#define	_SIO_H_

#include <stdio.h>

//----------------------------------------
//				Equates
//----------------------------------------

#define	SIO_DMEM_BLOCK_SIZE		8192

#define	SIO_READ_NO_COPY		0x0001	// This SIO supports ReadNoCopy

//----------------------------------------
//				Data Types
//----------------------------------------

		// DMEM_BLOCK

typedef struct	DMEM_BLOCK
{
	struct DMEM_BLOCK	*	pNext;
	char					data[SIO_DMEM_BLOCK_SIZE];
} DMEM_BLOCK;

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

		// Base Class

class	CSIO
{
public:

	CSIO();

	virtual
	~CSIO();

	virtual
	int									// returns bytes read or error code (POSIX)
	Read
	(
		char	*	pData,				// Were to put the data
		int			count				// # to read
	);

	virtual
	int									// returns bytes written or error code (POSIX)
	Write
	(
		const char	*	pData,				// Data to write
		int			count				// # to write
	);

	virtual
	int									// 0 or error code (POSIX)
	Seek
	(
		int			offset,				// Number of bytes from the origin
		int			origin				// SEEK_SET, SEEK_CUR, SEEK_END
	);

	virtual
	int									// 0 or error code (POSIX)
	Flush
	(
	);

	virtual
	int									// returns current position or error code (POSIX)
	Tell
	(
	);

	virtual
	int									// returns current position or error code (POSIX)
	Size
	(
	);

	int
	Printf
	(
		const char	*format,				// The format string
		...								// variable arg list	
	);

	int
	Putc
	(
		char		c	
	);

	int
	Puts
	(
		const char		*pData	
	);

	virtual
	int									// Returns # of bytes written or error
	CopyTo
	(
		CSIO	*pOut,					// The target SIO
		int		srcPos = 0,				// Source Position, 0 = Start of file
										// Default value is 0
		int		length = -1,			// # of bytes to copy, -1 = Whole File
										// Default value is -1
		int		destPos = -1			// Destination Position, -1 = Cur Position
										// Default value is -1
	);

	// Special Buffer Access Methods

	int									// returns bytes read or error code (POSIX)
	ReadNoCopy
	(
		char	**	pData,				// Ptr to a Ptr to return buffer ptr
		int			count				// Number of bytes wanted
	);

	inline
	int	
	GetFeatures()
	{
		return features;
	};

protected:

	int				features;			// Identifies features of the SIO
};

		// POSIX File Class

class CSIO_FP : public CSIO
{
public:

	CSIO_FP();

	virtual
	~CSIO_FP();

	void
	SetFP
	(
		FILE	*	fp
	);

	FILE *								// The file ptr
	GetFP
	(
		FILE	*	fp
	);

	int									// 0 = no error, !0 = POSIX error
	Open
	(
		const char	*	pName,				// File name
		const char	*	pMode				// File mode
	);

	int									// 0 = no error, !0 = POSIX error
	Close
	(
	);

	virtual
	int									// returns bytes read or error code (POSIX)
	Read
	(
		char	*	pData,				// Were to put the data
		int			count				// # to read
	);

	virtual
	int									// returns bytes written or error code (POSIX)
	Write
	(
		const char	*	pData,				// Data to write
		int			count				// # to write
	);

	virtual
	int									// 0 or error code (POSIX)
	Seek
	(
		int			offset,				// Number of bytes from the origin
		int			origin				// SEEK_SET, SEEK_CUR, SEEK_END
	);

	virtual
	int									// 0 or error code (POSIX)
	Flush
	(
	);

	virtual
	int									// returns current position or error code (POSIX)
	Tell
	(
	);

	virtual
	int									// returns current position or error code (POSIX)
	Size
	(
	);
	
private:
	
	FILE	*	fp;						// The file ptr
	int			weOpened;				// !0 if Open() was used

};

		// Static Memory Buffer Class

class CSIO_SMEM : public CSIO
{
public:

	CSIO_SMEM
	(
		char *	pBuffer,				// Ptr to the user buffer
		int		count,					// # of bytes of data in the buffer
		int		maxSize = 0				// max size the data can grow to in this buffer
										// if maxSize = 0, then buffer will not grow past count.
	);

	virtual
	~CSIO_SMEM();

	virtual
	int									// returns bytes read or error code (POSIX)
	Read
	(
		char	*	pData,				// Were to put the data
		int			count				// # to read
	);

	virtual
	int									// returns bytes written or error code (POSIX)
	Write
	(
		const char	*	pData,				// Data to write
		int			count				// # to write
	);

	virtual
	int									// 0 or error code (POSIX)
	Seek
	(
		int			offset,				// Number of bytes from the origin
		int			origin				// SEEK_SET, SEEK_CUR, SEEK_END
	);

	virtual
	int									// returns current position or error code (POSIX)
	Tell
	(
	);

	virtual
	int									// returns current position or error code (POSIX)
	Size
	(
	);

	char *								// Returns the ptr to the memory buffer
	GetBuffer
	(
	);

	int									// returns bytes read or error code (POSIX)
	ReadNoCopy
	(
		char	**	pData,				// Ptr to a Ptr to return buffer ptr
		int			count				// Number of bytes wanted
	);

private:
	
	char	*		pBuffer;			// Ptr to the buffer
	int				maxSize;			// Max size of the buffer
	int				size;				// Buffer Size
	int				position;			// current position

};

		// Dynamic Memory Buffer Class

class CSIO_DMEM : public CSIO
{
public:

	CSIO_DMEM
	(
		int		maxSize = 0				// max size the data can grow to in this buffer
										// if maxSize = 0, then there is no limit
	);

	virtual
	~CSIO_DMEM();

	virtual
	int									// returns bytes read or error code (POSIX)
	Read
	(
		char	*	pData,				// Were to put the data
		int			count				// # to read
	);

	virtual
	int									// returns bytes written or error code (POSIX)
	Write
	(
		const char	*	pData,				// Data to write
		int			count				// # to write
	);

	virtual
	int									// 0 or error code (POSIX)
	Seek
	(
		int			offset,				// Number of bytes from the origin
		int			origin				// SEEK_SET, SEEK_CUR, SEEK_END
	);

	virtual
	int									// returns current position or error code (POSIX)
	Tell
	(
	);

	virtual
	int									// returns current position or error code (POSIX)
	Size
	(
	);

	int									// returns bytes read or error code (POSIX)
	ReadNoCopy
	(
		char	**	pData,				// Ptr to a Ptr to return buffer ptr
		int			count				// Number of bytes wanted
	);

private:

	int									// 0 = No error
	AddBlock
	(
	);
	
	int				maxSize;			// Max size of the buffer
	int				size;				// Buffer Size
	int				position;			// current position

	DMEM_BLOCK	*	pFirstBlock;		// ptr to the first allocated memory block
};


#endif //_SIO_H_

