/*--------------------------------------------------------------------------------

	SXDB.cpp

	Copyright (c) 2002, Raritan Computer, Inc.

	This is a VERY simple DOM like data base for XML.

--------------------------------------------------------------------------------*/

#include	<assert.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	<pp/syms.h>
#include	<pp/SXDB.h>
#include	<pp/SXML_Out.h>

//----------------------------------------
//				Equates
//----------------------------------------

#define	isNameChar(a) ( isalpha(a) || a == '_' || a ==':' || a == '.' || a == '-' || isdigit(a) )

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Code
//----------------------------------------

//--------------------------------------------------------------------------------
//									CSXDB_Node
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	CSXDB_Node::CSXDB_Node
	(
	)
//
//	Initialize data items
//
//------------------------------------------------------------------------------//
{
	pParent = pSibling = pChild = NULL;

	pName = NULL;
	
	SetType( SXDB_TYPE_NODE );
}

//--------------------------------------------------------------------------------
//
	CSXDB_Node::~CSXDB_Node
	(
	)
//
//	Cleanup
//
//------------------------------------------------------------------------------//
{
	CSXDB_Node * p;

	// Delete the name

	if (pName)
		delete [] pName;

	pName = NULL;

	// Delete all our children

	while ( (p = Child()) != NULL)
		delete p;

	// Remove ourself

	Remove();
}

/*
//--------------------------------------------------------------------------------
//hack
	CSXDB_Node *						// Ptr to 
	CSXDB_Node::Dup
	(
		CSXDB_Node	*	pNewParent		// The parent of the duplicated node
	)
//
//	Duplicates a node, and all of it's children
//
//------------------------------------------------------------------------------//
*/
	
//--------------------------------------------------------------------------------
//
	SXDB_TYPE
	CSXDB_Node::GetType
	(
	)
//
//	Returns the node type
//
//------------------------------------------------------------------------------//
{
	return type;
}


//--------------------------------------------------------------------------------
//
	const char *
	CSXDB_Node::GetData
	(
	)
//
//	Returns ptr to the data for this node.
//	The meaning of this depends on the node type.
//
//------------------------------------------------------------------------------//
{
	return NULL;
}

//--------------------------------------------------------------------------------
//
	void
	CSXDB_Node::Strcpy
	(
		char	*	pString				// String to copy
	)
//
//	If this or this->GetData() == NULL, then dest string is "" otherwise
//	the string is copied
//
//------------------------------------------------------------------------------//
{
	const char	*p;

	if (pString == NULL)
		return;

	if (this != NULL)
	{
		p = this->GetData();
		if (p != NULL)
		{
			strcpy(pString,p);
			return;
		}
	}

	pString[0] = 0;

	return;
}

//--------------------------------------------------------------------------------
//
	void
	CSXDB_Node::Strncpy
	(
		char	*	pString,				// String to compare
		int			maxLength				// Max # of characters to copy
	)
//
//	If this or this->GetData() == NULL, then dest string is "" otherwise
//	the string is copied
//
//------------------------------------------------------------------------------//
{
	const char	*p;

	if (pString == NULL || maxLength == 0)
		return;

	if (this != NULL)
	{
		p = this->GetData();
		if (p != NULL)
		{
			strncpy(pString,p,maxLength);
			return;
		}
	}

	pString[0] = 0;

	return;
}

//--------------------------------------------------------------------------------
//
	int									// Same as strcmp
	CSXDB_Node::Strcmp
	(
		const char	*	pString				// String to compare
	)
//
//	If this or this->GetData() == NULL, then return -1, otherwise
//	uses strcmp rules
//
//------------------------------------------------------------------------------//
{
	const char	*p;

	if (this != NULL)
	{
		p = this->GetData();
		if (p != NULL && pString != NULL)
		{
			return strcmp(p,pString);
		}
	}

	return -1;
}

//--------------------------------------------------------------------------------
//
	int									// Same as stricmp
	CSXDB_Node::Stricmp
	(
		const char	*	pString				// String to compare
	)
//
//	If this or this->GetData() == NULL, then return -1, otherwise
//	uses stricmp rules
//
//------------------------------------------------------------------------------//
{
	const char	*string1;

	if (this != NULL)
	{
		string1 = this->GetData();
		if (string1 != NULL && pString != NULL)
		{
			int	diff;

			while (*string1 && *pString)
			{
				diff = (int) ( toupper(*string1) - toupper(*pString));
				if (diff != 0)
					return diff;

				string1++;
				pString++;
			}

			diff = (int) (*string1 - *pString);
			return diff;
		}
	}

	return -1;
}

//--------------------------------------------------------------------------------
//
	int									// Either 0 or SXML_ERROR_OUT_OF_MEMORY
	CSXDB_Node::SetData
	(
		const char	*	NOTUSED(pNewData)	// The new data
	)
//
//	Sets the data associated with this node to pNewData
//	The meaning of this depends on the node type.
//
//------------------------------------------------------------------------------//
{
	return SXML_ERROR_OUT_OF_MEMORY;
}

//--------------------------------------------------------------------------------
//
	int								// Either 0 or SXML_ERROR_OUT_OF_MEMORY
	CSXDB_Node::AddData
	(
		const char	*	NOTUSED(pData)
	)
//
//	Adds more data to the node
//	The meaning of this depends on the node type.
//
//------------------------------------------------------------------------------//
{
	return SXML_ERROR_OUT_OF_MEMORY;
}

//--------------------------------------------------------------------------------
//
	void
	CSXDB_Node::SetType
	(
		SXDB_TYPE	newType
	)
//
//	Sets the node type
//
//------------------------------------------------------------------------------//
{
	type = newType;
}

//--------------------------------------------------------------------------------
//
	int
	CSXDB_Node::Order
	(
	)
//
//	Returns the order (base 1) of the node type among it's siblings
//
//------------------------------------------------------------------------------//
{
	return 1;
}

//--------------------------------------------------------------------------------
//
	CSXDB_Node *						// Ptr to parent
	CSXDB_Node::Parent
	(
	)
//
//	Returns a the ptr to the parent node
//
//------------------------------------------------------------------------------//
{
	return pParent;
}

//--------------------------------------------------------------------------------
//
	CSXDB_Node *						// Ptr to child
	CSXDB_Node::Child
	(
	)
//
//	Returns a the ptr to the parent node
//
//------------------------------------------------------------------------------//
{
	return pChild;
}

//--------------------------------------------------------------------------------
//
	CSXDB_Node *						// ptr to sibling
	CSXDB_Node::Next
	(
	)
//
//	Returns a the ptr to the next sibling node
//	Returns NULL if there are no more siblings
//
//------------------------------------------------------------------------------//
{
	return pSibling;
}

//--------------------------------------------------------------------------------
//
	CSXDB_Node *						// ptr to privious sibling
	CSXDB_Node::Previous
	(
	)
//
//	Returns a the ptr to the previous sibling node.
//	Returns NULL if this is the first child
//
//------------------------------------------------------------------------------//
{
	CSXDB_Node	*p = NULL;

	if (pParent)
	{
		if (pParent->pChild != this)
		{
			p = pParent->pChild;

			while (p != NULL && p->pSibling != this)
				p = p->pSibling;
		}
	}

	return p;
}

//--------------------------------------------------------------------------------
//
	CSXDB_Node *					// NULL if not found, else node ptr
	CSXDB_Node::FindChildOfType
	(
		SXDB_TYPE	_type,			// The node type we are looking for
		CSXDB_Node  *	pLast,			// NULL to find the first, or the last found for next
		int		ocurrance		// Find the nth occurance of the element
	)
//
//	If pLast == NULL, then find the first child of the specified type.
//	If pLast != NULL, then find the next child after pLast with the specified type.
//
//------------------------------------------------------------------------------//
{
	CSXDB_Node	*p = NULL;
	
	if (pLast == NULL)
		p = pChild;
	else
		p = pLast->Next();

	if (ocurrance < 1)
		return NULL;

	do
	{
		while (p != NULL && p->GetType() != _type)
			p = p->Next();
		ocurrance --;
	} while (p != NULL && ocurrance > 0);

	return p;
}

//--------------------------------------------------------------------------------
//
	CSXDB_Node *						// NULL if not found, else node ptr
	CSXDB_Node::FindChildOfTypeByName
	(
		SXDB_TYPE		_type,			// The node type we are looking for
		const char	*	_pName,			// The name we are searching for
		CSXDB_Node	*	pLast,			// NULL to find the first, or the last found for next
		int			ocurrance		// Find the nth occurance of the element
	)
//
//	If pLast == NULL, then find the first child of the specified type.
//	If pLast != NULL, then find the next child after pLast with the specified type.
//
//------------------------------------------------------------------------------//
{
	CSXDB_Node	*p = NULL;
	
	if (pLast == NULL)
		p = pChild;
	else
		p = pLast->Next();

	if (ocurrance < 1)
		return NULL;

	do
	{
		while (p != NULL && p->GetType() != _type)
			p = p->Next();

		if (p != NULL)
		{
			if (strcmp(p->GetName(),_pName)==0)
			{
				ocurrance --;
				if (ocurrance == 0)
					break;
			}
			p = p->Next();
		}

	} while (p != NULL);

	return p;
}

//--------------------------------------------------------------------------------
//
	int									// The number of children that match type
	CSXDB_Node::CountChildOfType
	(
		SXDB_TYPE		_type			// The node type we are looking for
	)
//
//	Counts the child nodes that match type
//
//------------------------------------------------------------------------------//
{
	CSXDB_Node	*p = NULL;
	int			count = -1;
	
	do
	{
		p = FindChildOfType( _type, p );
		count ++;
	} while (p != NULL);

	return count;
}

//--------------------------------------------------------------------------------
//
	void
	CSXDB_Node::AddChild
	(
		CSXDB_Node *	pNewChild		// Ptr to the new child to add
	)
//
//	Adds a child at the end of the child list
//
//------------------------------------------------------------------------------//
{
	CSXDB_Node	*p = NULL;

	#ifdef DEBUG
		assert( pNewChild->pParent == NULL );
		assert( pNewChild->pSibling == NULL );
	#endif

	pNewChild->pParent = this;

	if (pChild == NULL)
		pChild = pNewChild;
	else
	{
		p = pChild;

		while (p->pSibling != NULL)
			p = p->pSibling;

		p->pSibling = pNewChild;
	}
}

//--------------------------------------------------------------------------------
//
	void
	CSXDB_Node::InsertChild
	(
		CSXDB_Node *	pNewChild,		// Ptr to the new child to insert
		CSXDB_Node *	pBeforeChild	// NULL or the child to be before
	)
//
//	Inserts a child into the child list.
//	If pBeforeChild is NULL, then pNewChild is added at the start of the list.
//	if pBeforeChild points to a child of this node, then pNewChild will be inserted
//	just before pBeforeChild in the list.
//	If pBeforeChild does not point to a child of this node (bug!) then pNewChild
//	will be added to the end of the list.
//
//------------------------------------------------------------------------------//
{
	CSXDB_Node	*p = NULL;

	#ifdef DEBUG
		assert( pNewChild->pParent == NULL );
		assert( pNewChild->pSibling == NULL );
	#endif

	if (pBeforeChild == NULL || (pChild == pBeforeChild) )
	{
		pNewChild->pSibling = pChild;
		pChild = pNewChild;
	}
	else
	{
		p = pChild;

		while (p->pSibling != NULL && p->pSibling != pBeforeChild)
			p = p->pSibling;

		pNewChild->pSibling = p->pSibling;
		p->pSibling = pNewChild;
	}
}

//--------------------------------------------------------------------------------
//
	void
	CSXDB_Node::Remove
	(
	)
//
//	Removes this node form it's parent's list
//
//------------------------------------------------------------------------------//
{
	CSXDB_Node	*p = NULL;

	if (pParent)
	{
		if (pParent->pChild == this)
			pParent->pChild = pSibling;
		else
		{
			p = pParent->pChild;

			while (p != NULL && p->pSibling != this)
				p = p->pSibling;

				assert( p != NULL);

			if (p != NULL)
				p->pSibling = pSibling;
		}
	}

	pParent = pSibling = NULL;
}

//--------------------------------------------------------------------------------
//
	const char *
	CSXDB_Node::GetName
	(
	)
//
//	Returns the name.
//
//------------------------------------------------------------------------------//
{
	return pName;
}

//--------------------------------------------------------------------------------
//
	int									// Either 0 or SXML_ERROR_OUT_OF_MEMORY
	CSXDB_Node::SetName
	(
		const char	*	pNewName			// The new name
	)
//
//	Sets the name. The name string is copied to a newly allocated array.
//
//------------------------------------------------------------------------------//
{
	int	len;

	assert( pNewName != NULL );

   // Check for self assignment 

    if (pName == pNewName)
    {
        // Do nothing
        return 0;
    }

	// Remove the old name

	if (pName != NULL)
	{
		delete [] pName;
		pName = NULL;
	}

	if (pNewName != NULL)
	{
		len = strlen( pNewName );

		pName = new char[len+1];

		if (pName != NULL)
			strcpy(pName,pNewName);
		else
			return SXML_ERROR_OUT_OF_MEMORY;
	}

	return 0;
}

//--------------------------------------------------------------------------------
//									CSXDB_Data
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	CSXDB_Data::CSXDB_Data
	(
	)
//
//	Initialize data items
//
//------------------------------------------------------------------------------//
{
	SetType( SXDB_TYPE_DATA );

	pData = NULL;
}

//--------------------------------------------------------------------------------
//
	CSXDB_Data::~CSXDB_Data
	(
	)
//
//	Cleanup
//
//------------------------------------------------------------------------------//
{
	if (pData)
		delete [] pData;

	pData = NULL;
}

//--------------------------------------------------------------------------------
//
	const char *
	CSXDB_Data::GetData
	(
	)
//
//	Returns the name.
//
//------------------------------------------------------------------------------//
{
	if (this == NULL)
		return NULL;

	return pData;
}

//--------------------------------------------------------------------------------
//
	int									// Either 0 or SXML_ERROR_OUT_OF_MEMORY
	CSXDB_Data::SetData
	(
		const char	*	pNewData			// The new name
	)
//
//	Sets the name. The name string is copied to a newly allocated array.
//
//------------------------------------------------------------------------------//
{
	int	len;

    // Check for self assignment 
    if (pData == pNewData)
    {
        // Do nothing
        return 0;
    }

	// Remove the old name

	if (pData != NULL)
	{
		delete [] pData;
		pData = NULL;
	}

	if (pNewData != NULL)
	{
		len = strlen( pNewData );

		pData = new char[len+1];

		if (pData != NULL)
			strcpy(pData,pNewData);
		else
			return SXML_ERROR_OUT_OF_MEMORY;
	}

	return 0;
}

//--------------------------------------------------------------------------------
//									CSXDB_Data
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	CSXDB_Attribute::CSXDB_Attribute
	(
	)
//
//	Initialize data items
//
//------------------------------------------------------------------------------//
{
	SetType( SXDB_TYPE_ATTRIBUTE );
}

//--------------------------------------------------------------------------------
//
	CSXDB_Attribute::~CSXDB_Attribute
	(
	)
//
//	Cleanup
//
//------------------------------------------------------------------------------//
{
}

//--------------------------------------------------------------------------------
//
	const char		*					// Ptr to the data
	CSXDB_Attribute::GetData
	(
	)
//
//	Gets the data for an attribute
//
//------------------------------------------------------------------------------//
{
	CSXDB_Data * pData;

	if (this == NULL)
		return NULL;

	if (this->Child() && this->Child()->GetType() == SXDB_TYPE_DATA)
	{
		pData = (CSXDB_Data *) this->Child();
		return pData->GetData();
	}

	return NULL;
}

//--------------------------------------------------------------------------------
//
	int									// Either 0 or SXML_ERROR_OUT_OF_MEMORY
	CSXDB_Attribute::SetData
	(
		const char	*	pDataIn
	)
//
//	Sets the contents of the data node for an attribute
//
//------------------------------------------------------------------------------//
{
	CSXDB_Data * pData;
	int			result = 0;

	if (this->Child() && this->Child()->GetType() == SXDB_TYPE_DATA)
	{
		pData = (CSXDB_Data *) this->Child();
		result = pData->SetData( pDataIn );
	}
	else
	{
		pData = new CSXDB_Data;
		result = pData->SetData( pDataIn );

		if (result != 0)
			delete pData;

		this->AddChild( pData );
	}

	return result;
}

//--------------------------------------------------------------------------------
//									CSXDB_Element
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	CSXDB_Element::CSXDB_Element
	(
	)
//
//	Initialize data items
//
//------------------------------------------------------------------------------//
{
	SetType( SXDB_TYPE_ELEMENT );
}

//--------------------------------------------------------------------------------
//
	CSXDB_Element::~CSXDB_Element
	(
	)
//
//	Cleanup
//
//------------------------------------------------------------------------------//
{
}

//--------------------------------------------------------------------------------
//
	CSXDB_Element	*					// Ptr to the new element or null if failed
	CSXDB_Element::AddElement
	(
		const char	*	_pName
	)
//
//	Creates a new element as a child of this element
//
//------------------------------------------------------------------------------//
{
	CSXDB_Element	*	p = new CSXDB_Element;

	if (p==NULL)
		return NULL;

	if (_pName != NULL)
	{
		if (p->SetName( _pName ) != 0)
		{
			delete p;
			return NULL;
		}
	}

	this->AddChild( p );

	return p;
}

//--------------------------------------------------------------------------------
//
	CSXDB_Attribute	*					// Ptr to the new element or null if failed
	CSXDB_Element::AddAttribute
	(
		const char	*	_pName,
		const char	*	pData
	)
//
//	Creates a new attribute as a child of this element
//
//------------------------------------------------------------------------------//
{
	CSXDB_Attribute	*	p;
	int				nameResult,dataResult;

	// See if there is already an attribute of with the same name

	p = (CSXDB_Attribute *) this->FindChildOfTypeByName( SXDB_TYPE_ATTRIBUTE, _pName, NULL );

	if (p != NULL)
	{
		// Overwrite the old attribute with the new attribute.

		// do not set the name again, name already equals new name
		//nameResult = p->SetName( _pName );
		nameResult = 0;
		dataResult = p->SetData( pData );

		if (nameResult == 0 && dataResult == 0)
			return p;
		else
			return NULL;
	}

	// Create the attribute

	p = new CSXDB_Attribute;

	if (p==NULL)
		return NULL;

	if (_pName != NULL)
	{
		nameResult = p->SetName( _pName );
		dataResult = p->SetData( pData );

		if (nameResult != 0 || dataResult != 0)
		{
			delete p;
			return NULL;
		}
	}

	this->AddChild( p );

	return p;
}

//--------------------------------------------------------------------------------
//
	CSXDB_Element	*					// Ptr to the new element or null if failed
	CSXDB_Element::AddElementWithData
	(
		const char	*	_pName,
		const char	*	pData
	)
//
//	Creates a new element as a child of this element and adds data to it
//
//------------------------------------------------------------------------------//
{
	CSXDB_Element	*	p = new CSXDB_Element;

	if (p==NULL)
		return NULL;

	if (_pName != NULL)
	{
		if (p->SetName( _pName ) != 0)
		{
			delete p;
			return NULL;
		}

		// Add the data

		if (p->AddData( pData ) != 0)
		{
			delete p;
			return NULL;
		}
	}

	this->AddChild( p );

	return p;
}

//--------------------------------------------------------------------------------
//
	int								// Either 0 or SXML_ERROR_OUT_OF_MEMORY
	CSXDB_Element::AddData
	(
		const char	*	pData
	)
//
//	Creates a new data node as a child of this element
//
//------------------------------------------------------------------------------//
{
	CSXDB_Data	*	p = new CSXDB_Data;

	if (p==NULL)
		return SXML_ERROR_OUT_OF_MEMORY;

	if (pData != NULL)
		p->SetData( pData );

	this->AddChild( p );

	return p == NULL ? SXML_ERROR_OUT_OF_MEMORY : 0;
}

//--------------------------------------------------------------------------------
//
	const char *
	CSXDB_Element::GetData
	(
	)
//
//	Returns a ptr to the data of the first CSXDB_Data node for this element
//
//------------------------------------------------------------------------------//
{
	CSXDB_Data * pData;

	if (this == NULL)
		return NULL;

	for ( pData = (CSXDB_Data *) this->Child(); pData != NULL; pData = (CSXDB_Data*) pData->Next())
	{
		if (pData->GetType() == SXDB_TYPE_DATA)
			return pData->GetData();
	}

	return NULL;
}

//--------------------------------------------------------------------------------
//
	int								// Either 0 or SXML_ERROR_OUT_OF_MEMORY
	CSXDB_Element::SetData
	(
		const char	*	pData
	)
//
//	Removes all existing data elements and then calls AddData to create a new
//	data element with pData
//
//------------------------------------------------------------------------------//
{
	CSXDB_Node * pNode;

	while ( (pNode = this->FindChildOfType( SXDB_TYPE_DATA, NULL )) != NULL )
    {
        // Check for self assignment
        if (pNode->GetData() == pData)
        {
            // Do nothing
            return 0;
        }

		delete pNode;
    }


	return AddData( pData );
}

//--------------------------------------------------------------------------------
//
	int
	CSXDB_Element::Order
	(
	)
//
//	Returns the order (base 1) of the node type among it's siblings
//
//------------------------------------------------------------------------------//
{
	CSXDB_Node	*pNode;
	CSXDB_Node	*pParentNode;
	int			index = 0;

	assert( this->Parent() != NULL );

	pParentNode = this->Parent();
	pNode = NULL;
	index = 1;

	while ( (pNode = pParentNode->FindChildOfTypeByName( SXDB_TYPE_ELEMENT, this->GetName(), pNode)) != NULL)
	{
		if (pNode == this)
			return index;
		index++;
	}

	return SXML_ERROR_XPATH_NULL_SET; // Should never get here
}

//--------------------------------------------------------------------------------
//									CSXDB_Document
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	CSXDB_Document::CSXDB_Document
	(
	)
//
//	Initialize data items
//
//------------------------------------------------------------------------------//
{
	SetType( SXDB_TYPE_DOCUMENT );
}

//--------------------------------------------------------------------------------
//
	CSXDB_Document::~CSXDB_Document
	(
	)
//
//	Cleanup
//
//------------------------------------------------------------------------------//
{
}

//--------------------------------------------------------------------------------
//									CSXDB
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	CSXDB::CSXDB
	(
	)
//
//	Initialize data items
//
//------------------------------------------------------------------------------//
{
	pRoot = new CSXDB_Document;
}

//--------------------------------------------------------------------------------
//
	CSXDB::~CSXDB
	(
	)
//
//	Cleanup
//
//------------------------------------------------------------------------------//
{
	if (pRoot != NULL)
		delete pRoot;
}

//--------------------------------------------------------------------------------
//
	CSXDB_Node *
	CSXDB::Root
	(
	)
//
//	Returns a ptr to the root node
//
//------------------------------------------------------------------------------//
{
	return pRoot;
}

//--------------------------------------------------------------------------------
//
	void
	CSXDB::SetRoot
	(
		CSXDB_Node	*pNewRoot
	)
//
//	Sets a new root. Used for loading entire data bases
//
//------------------------------------------------------------------------------//
{
	if (pRoot != NULL)
		delete pRoot;

	pRoot = pNewRoot;
}

/*
//--------------------------------------------------------------------------------
//
	int
	CSXDB::CreatePath
	(
		const char	*pXPath,				// XPath to the node to get data from
		CSXDB_Node *pContextNode		// The context node to start searching from
	)
//
//	Creates a path if is does not exist. The xPath statement can only have 
//	elements. It may contain an index. Example:
//
//	/Parent/Child/Node[2]  - Creates /Parent, /Child, and /Nodes[1] and /Nodes[2]
//
//	SECURITY = NONE !
//
//------------------------------------------------------------------------------//
{
	// HACK

	return -1;
}
*/

//--------------------------------------------------------------------------------
//
	CSXDB_Node *						// Ptr to the node
	CSXDB::GetNodeFromXPath
	(
		const char	*pXPath,				// XPath to the node to get data from
		void	*pUser,					// User account
		CSXDB_Node *pContextNode		// The context node to start searching from
	)
//
//	Returns the ptr node pointed to by xpath
//
//	SECURITY is handled by XPath
//
//------------------------------------------------------------------------------//
{
	CSXPath		p;

	p.Parse( pXPath, this, pContextNode, 0, pUser );
	return p.Enum(0);
}

//--------------------------------------------------------------------------------
//
	CSXDB_Node *						// Ptr to the node
	CSXDB::GetNodeFromID
	(
		const char	*pID,					// Ptr to the unique ID
		void	*pUser,					// User account
		CSXDB_Node *pContextNode		// The context node to start searching from
	)
//
//	Returns the ptr node with the unique ID
//
//	SECURITY is handled by XPath
//
//------------------------------------------------------------------------------//
{
	CSXPath		p;
	char		path[40];

	sprintf(path,"//*[@id=\"%s\"]", pID );

	p.Parse( path, this, pContextNode, 0, pUser );
	return p.Enum(0);
}

//--------------------------------------------------------------------------------
//
	const char *
	CSXDB::GetData
	(
		const char	*pXPath,				// XPath to the node to get data from
		void	*pUser,					// User account
		CSXDB_Node *pContextNode		// The context node to start searching from
	)
//
//	Returns the ptr to the data of the element or attribute.
//
//	SECURITY is handled by XPath
//
//------------------------------------------------------------------------------//
{
	CSXPath		p;
	int			result;

	if (this == NULL)
		return NULL;

	result = p.Parse( pXPath, this, pContextNode, 0, pUser );

	if (result < 1)
		return NULL;

	return p.Enum(0)->GetData();
}

//--------------------------------------------------------------------------------
//
	const char *
	CSXDB::GetData
	(
		const char	*pXRoot,				// XPath to the root node
		const char	*pSubNode,				// Ptr t othe sub node
		void	*pUser,					// User account
		CSXDB_Node *pContextNode		// The context node to start searching from
	)
//
//	Handy little function that concatinates the two strings and then calls GetData()
//
//	SECURITY handled by XPath
//
//------------------------------------------------------------------------------//
{
	char	xpath[256];

	sprintf(xpath,"%s/%s",pXRoot,pSubNode);

	return GetData( xpath, pUser, pContextNode );
}

//--------------------------------------------------------------------------------
//
	int									// Error code or # updated
	CSXDB::PutData
	(
		const char	*pXPath,				// XPath to the node to get data from
		const char	*pSubNode,				// Ptr to the name of the element or attribute
		SXDB_TYPE type,					// SXDB_TYPE_ELEMENT or SXDB_TYPE_ATTRIBUTE
		const char	*pData,					// Ptr to the data to put
		void	*pUser,					// User account
		CSXDB_Node *pContextNode,		// The context node to start searching from
		int		append					// !0 = force append
	)
//
//	Sets the data of an element or attribute.
//	If the element or attribute exists, it will be over written.
//	if the element or attribute does not exist, it will be added
//
//	SECURITY is handled by XPath
//
//------------------------------------------------------------------------------//
{
	CSXPath		p;
	int			result;
	CSXDB_Node	*pNode,*pNameNode;
	int			x = 0;

	result = p.Parse( pXPath, this, pContextNode, 0, pUser );

	if (result <0)
		return result;


	while ( (pNode = p.Enum(x)) )
	{
		pNameNode = pNode->FindChildOfTypeByName( type, pSubNode, NULL );

		if (pNameNode != NULL && !append)
			pNameNode->SetData( pData );
		else
		{
			if (type == SXDB_TYPE_ELEMENT)
				((CSXDB_Element *) pNode)->AddElementWithData( pSubNode, pData );
			else
				((CSXDB_Element *) pNode)->AddAttribute( pSubNode, pData );
		}

		x++;
	}

	return x;
}

//--------------------------------------------------------------------------------
//
	int									// returns error code
	CSXDB::Get
	(
		const char	*	_pRoot,				// Ptr to the XPath statement defining the root
		const char	*	pNodes,				// Ptr to the list of top level nodes to include
		const char	*	pSubNodes,			// Ptr to the list of sub nodes to include
		int			depth,				// # of levels ot top level nodes to transvers (0=no limit)
		CSIO	*	pOut,				// Oupput results
		void	*	pUser				// User account
	)
//
//	Processes a database Get command.
//
//------------------------------------------------------------------------------//
{
	CSXDB_Node	*	pRootNode;
	int				result;
	NODE_SEARCH_INFO info;
	CSXPath			p;
	int				x;

	// Prepare search data

	info.depth = depth;
	info.pUser = pUser;
	info.pOut  = pOut;

	// Parse the node names

	info.pTopNodes = new NODE_NAMES;
	info.pSubNodes = new NODE_NAMES;

	if (info.pTopNodes == NULL || info.pSubNodes == NULL)
	{
		result = SXML_ERROR_OUT_OF_MEMORY;
		goto EXIT;
	}

	ParseNodeNames(pNodes, info.pTopNodes);
	ParseNodeNames(pSubNodes, info.pSubNodes);

	if (info.pTopNodes->count == 0)
	{
		result = SXML_ERROR_PARAMETER;
		goto EXIT;
	}

	// Parse the root

	result = p.Parse( _pRoot, this, NULL, 0, pUser );

	if (result < 1)
		goto EXIT;

	for (x=0; (pRootNode = p.Enum(x)); x++)
	{
		if (pRootNode->GetType() == SXDB_TYPE_DOCUMENT)
		{
			// HACK - Someday supprt document stuff
			pRootNode = pRootNode->Child();
			if (pRootNode== NULL)
			{
				result = 0;
				goto EXIT;
			}
		}

		result = Get_NodeSearch( pRootNode, 0, &info );

		if (result < 0)
			goto EXIT;
	}

	result = pOut->Putc(0x0D) != EOF ? 0 : SXML_ERROR_OUT_OF_MEMORY;
	result = pOut->Putc(0x0A) != EOF ? 0 : SXML_ERROR_OUT_OF_MEMORY;

EXIT:
	if (info.pTopNodes != NULL)
		delete info.pTopNodes;
	
	if (info.pSubNodes != NULL)
		delete info.pSubNodes;
	
	return result;
}

//--------------------------------------------------------------------------------
//
	int									// returns error code
	CSXDB::Get_NodeSearch
	(
		CSXDB_Node	*	pRootNode,		// Potential top level node
		int				level,			// # of levels ot top level nodes to transvers
		NODE_SEARCH_INFO * pInfo		// static info used be each level of recursion
	)
//
//	Processes a database Get command.
//
//------------------------------------------------------------------------------//
{
	NODE_NAMES	*pNodeNames;
	CSXDB_Node	*pNode;
	int			access;

	// Enum children and compare to the names

	if (pRootNode->GetType() != SXDB_TYPE_ELEMENT)
		return 0;

	// See if this is a node of interest
	// if level == -1, then we are searching for subnodes

	if (level == -1)
		pNodeNames = pInfo->pSubNodes;
	else
		pNodeNames = pInfo->pTopNodes;

	if (SearchNodeNames(pRootNode, pNodeNames) == 0)
	{
		// SECURITY - Check to see if this user can access this element

		if (pInfo->pUser != NULL)
		{
			// if access if yes or unknown, then continue, else return
			access = CheckAccess( pRootNode, pInfo->pUser, SXDB_ACCESS_READ, 1 );			
			if (access == 0)
				return 0;
		}

		// Output tag

		pInfo->pOut->Putc('<');
		pInfo->pOut->Puts(pRootNode->GetName());

		// Output attributes

		pNode = NULL;

		do
		{
			pNode = pRootNode->FindChildOfType( SXDB_TYPE_ATTRIBUTE, pNode );

			if (pNode == NULL)
				break;

			if (SearchNodeNames(pNode, pInfo->pSubNodes) == 0)
			{
				pInfo->pOut->Printf(" %s=\"%s\"",pNode->GetName(), ((CSXDB_Attribute *) pNode)->GetData() );
			}
		} while (1);
		
		pInfo->pOut->Printf(">");

		// Output all other nodes

		pNode = pRootNode->Child();

		while (pNode != NULL)
		{

			switch (pNode->GetType())
			{
				case SXDB_TYPE_ATTRIBUTE:
				case SXDB_TYPE_DOCUMENT:
				case SXDB_TYPE_NODE:
					break;
					
				case SXDB_TYPE_ELEMENT:

					if (level > -1 && (pInfo->depth == 0 || level < pInfo->depth))
					{
						if (Get_NodeSearch( pNode, level++, pInfo ) != 0)
							Get_NodeSearch( pNode, -1, pInfo );
					}
//					else
//hack hack - I think this is wrong, but make sure removing does not break anything
//						Get_NodeSearch( pNode, -1, pInfo ); // HACK - Will this recursively see lower and lower sub elements ?

					break;

				case SXDB_TYPE_DATA:

					SXMLOut(pInfo->pOut,((CSXDB_Data *) pNode)->GetData() );
					break;
			}

			pNode = pNode->Next();
		}

		pInfo->pOut->Printf("</%s>\n",pRootNode->GetName());
	}
	else
		return -1;

	return 0;
}


//--------------------------------------------------------------------------------
//
	int									// returns error code or order of the node
	CSXDB::Order
	(
		const char	*	pXPath,				// The XPath statement to evauluate
		void	*	pUser				// User account
	)
//
//	Process a database Order command.
//	Returns the order of the node in relation to it's parent.
//	xPath must equate to the only one element
//	1 = the first occurrance.
//
//	SECURITY handled by XPath
//
//------------------------------------------------------------------------------//
{
	int			result;
	CSXPath		parser;
	CSXDB_Node	*pTargetNode;

	result = parser.Parse( pXPath, this, NULL, 0, pUser );

	if (result < 0)
		return result;
	else if (result <1)
		return SXML_ERROR_XPATH_NULL_SET;

	pTargetNode = parser.Enum(0);

	return pTargetNode->Order();
}

//--------------------------------------------------------------------------------
//
	int									// returns error code or # of nodes found
	CSXDB::Count
	(
		const char	*	pXPath,				// The XPath statement to evauluate
		void	*	pUser,				// User account
		CSXDB_Node *pContextNode		// The xpath context
	)
//
//	Process a database count command.
//	Returns the number of nodes represented by the XPath statement
//
//	SECURITY handled by XPath
//
//------------------------------------------------------------------------------//
{
	CSXPath	parser;

	return parser.Parse( pXPath, this, pContextNode, 0, pUser );
}

//--------------------------------------------------------------------------------
//
	int									// returns error code or # of nodes found
	CSXDB::Count
	(
		const char	*	pXPath,				// The XPath statement to evauluate
		const char	*	pSubNode,			// Sub node of pXPath to count
		void	*	pUser				// User account
	)
//
//	Process a database count command.
//	Returns the number of nodes represented by the XPath statement
//
//	SECURITY handled by XPath
//
//------------------------------------------------------------------------------//
{
	char	xpath[256];

	sprintf(xpath,"%s/%s",pXPath,pSubNode);

	return Count( xpath, pUser );
}

//--------------------------------------------------------------------------------
//
	int									// returns error code or number of top level nodes updated
	CSXDB::Update
	(
		const char	*	_pRoot,				// Ptr to the XPath statement defining the root
		CSXDB	*	pDB,				// The new data
		int			overwrite,			// 0 = Append (on over write), !0 = Update (over write)
		void	*	pUser				// User account
	)
//
//	Processes a database Update command.
//	The nodes appended to pRoot are removed from pDB.
//
//------------------------------------------------------------------------------//
{
	CSXPath		parser;
	CSXDB_Node	*pTop;		// Top of new data

	pTop = pDB->Root();

	if (pTop == NULL)
		return 0;

	pTop = pTop->Child();

	if (pTop == NULL)
		return 0;

	pTop->Remove();

	return Update(_pRoot, pTop, overwrite, pUser );
}

//--------------------------------------------------------------------------------
//
	int									// returns error code or number of top level nodes updated
	CSXDB::Update
	(
		const char	*	_pRoot,				// Ptr to the root Node
		CSXDB_Node*	pUserData,			// The new data
		int			overwrite,			// 0 = Append (on over write), !0 = Update (over write)
		void	*	pUser				// User account
	)
//
//	Processes a database Update command.
//
//------------------------------------------------------------------------------//
{
	CSXPath		parser;
	CSXDB_Node	*pRootNode; // Parent of what is changing
	CSXDB_Node *pTargetNode;
	CSXDB_Node *pNode;
	int			result = 0;
	int			count;
	int			last;
	int			x;
	int			access;

	result = parser.Parse( _pRoot, this, NULL, 0, pUser );

	if (result < 0)
		goto EXIT;

	count = result;

	// For each match in to the xpath, update the node

	for (x = 0; (pRootNode = parser.Enum(x)) != NULL; x++)
	{
		last = x == count-1;

		// SECURITY - Make sure we can write to this node

		if (pUser != NULL)
		{
			// hack - need to check sub nodes !
			// if access if yes or unknown, then continue, else return
			access = CheckAccess( pRootNode, pUser, SXDB_ACCESS_WRITE, 1 );			
			if (access == 1)
				break;
		}

		// Make sure the parent is there 

		switch (pUserData->GetType())
		{
			case SXDB_TYPE_ATTRIBUTE:
				if (pRootNode->GetType() != SXDB_TYPE_ELEMENT)
					result = SXML_ERROR_XPATH_SYNTAX;
					goto EXIT;

				pTargetNode = pRootNode->FindChildOfTypeByName( SXDB_TYPE_ATTRIBUTE, pUserData->GetName(), NULL );

				if (pTargetNode == NULL)
					pTargetNode = (CSXDB_Node *) ((CSXDB_Element *) pRootNode)->AddAttribute( pUserData->GetName(), NULL);

				break;

			case SXDB_TYPE_ELEMENT:
				pTargetNode = pRootNode->FindChildOfTypeByName( SXDB_TYPE_ELEMENT, pUserData->GetName(), NULL );

				if (pTargetNode == NULL || !overwrite)
					pTargetNode = ((CSXDB_Element *) pRootNode)->AddElement( pUserData->GetName() );


				// hack - need to check sub nodes for security

				break;

			case SXDB_TYPE_DATA:
			default:
				pTargetNode = pRootNode;
				break;
		}
		
		// For each child of the new data, merge in the data

		for (pNode = pUserData->Child(); pNode != NULL; )
		{
			/*
			if (!last)
			{
				// Duplicate the data
				// Hack - not implemented
			}
			else*/
			{
				// Remove the data from the source

				pNode->Remove();
			}

			result = Update_Node( pTargetNode, pNode, overwrite, pUser );

			if (result != 0)
				break;

			//if (last)
				pNode = pUserData->Child();
			//else
			//	pNode = pNode->Next();
		}

		break; // HACK - Dup for multiples
	}

EXIT:
	delete pUserData;

	return result;
}

//--------------------------------------------------------------------------------
//
	int									// returns error code or number of top level nodes updated
	CSXDB::Update_Node
	(
		CSXDB_Node*	pRootNode,			// Ptr node to update
		CSXDB_Node*	pUserData,			// Ptr to the new child node 
		int			overwrite,			// 0 = Append (on over write), !0 = Update (over write)
		void	*	pUser				// User account
	)
//
//	Processes a database Update command.
//
//------------------------------------------------------------------------------//
{
	CSXDB_Node	*pNode;
	int			y;

	// SECURITY - Make sure we can write to this node

	if (pUser != NULL)
	{
		if ( (CheckAccess( pRootNode, pUser, SXDB_ACCESS_WRITE ) <= 1 ) )
			return 0;
	}

	// If we are updating, delete the old nodes we are replacing
	// This is true for appending attributes too, since there can only be one of any attribute

	if (overwrite || pUserData->GetType() == SXDB_TYPE_ATTRIBUTE)
	{
		switch (pUserData->GetType())
		{
			case SXDB_TYPE_DATA:
				for (y = 0; (pNode = pRootNode->FindChildOfType( SXDB_TYPE_DATA, NULL )) != NULL; y++)
					delete pNode;
				break;

			case SXDB_TYPE_ATTRIBUTE:
				pNode = pRootNode->FindChildOfTypeByName( SXDB_TYPE_ATTRIBUTE, pUserData->GetName(), NULL );

				if (pNode)
					delete pNode;
				break;

			case SXDB_TYPE_ELEMENT:
				for (y = 0; (pNode = pRootNode->FindChildOfTypeByName( SXDB_TYPE_ELEMENT, pUserData->GetName(), NULL )) != NULL; y++)
					delete pNode;
				break;

			default:
				return SXML_ERROR_DB_CORRUPT;
		}
	}

	// Append the new data

	pRootNode->AddChild( pUserData );
	
	return 0;

}

//--------------------------------------------------------------------------------
//
	int									// returns error code or # of nodes deleted (top level)
	CSXDB::Delete
	(
		const char	*	_pRoot,				// Ptr to the XPath statement defining the nodes to delete
		void	*	pUser				// User account
	)
//
//	Processes a database Delete command.
//
//------------------------------------------------------------------------------//
{
	CSXPath		parser;
	CSXDB_Node	*pNode;
	int			x;
	int			result;

	result = parser.Parse( _pRoot, this );	// Super user access, delete check below does security

	if (result > 0)
	{
		result = 0;

		for (x = 0; (pNode = parser.Enum(x)) != NULL; x++)
		{
			// SECURITY

			if (pUser != NULL)
			{
				if ( (CheckAccess( pNode, pUser, SXDB_ACCESS_DELETE ) <= 1 ) )
					continue;
			}

			// Delete it

			delete pNode;
			result++;
		}
	}

	return result;
}

//--------------------------------------------------------------------------------
//
	int									// !0 if access is allowed
										// 0 = Not allowed
										// -1 = unknown for this node
	CSXDB::CheckAccess
	(
		CSXDB_Node	* NOTUSED(pNode),				// The node to authorize
		void		* NOTUSED(pUser),				// User account
		int		NOTUSED(accessType),		// SXDB_ACCESS_xxx
		int		NOTUSED(oneLevel)		// !0 = only check pNode, not it's ansestors
	)
//
//	Checks to see if the user is allowed to perform the specifide access to the 
//	node.
//
//------------------------------------------------------------------------------//
{
	return 1;
}

//--------------------------------------------------------------------------------
//
	int									// returns error code or # of nodes deleted (top level)
	CSXDB::ParseNodeNames
	(
		const char	*	pText,				// Text list of names
		NODE_NAMES *pNodeNames			// Ptr to the node names struct
	)
//
//	Parses a list of node names
//
//------------------------------------------------------------------------------//
{
	int		x;

	memset(pNodeNames,0,sizeof(*pNodeNames));

	if (pText == NULL)
		return 0;

	for (x=0; x<SXDB_MAX_NODE_NAMES && *pText; x++)
	{
		while (!isNameChar(*pText) && *pText && *pText != '@')
		{
			if (*pText == '*')
			{
				pNodeNames->count = -1;
				return 1;
			}

			pText++;
		}

		if (*pText == '@')
		{
			pText++;

			pNodeNames->Nodes[x].type = SXDB_TYPE_ATTRIBUTE;
		}
		else
			pNodeNames->Nodes[x].type = SXDB_TYPE_ELEMENT;
		
		if (*pText == 0)
			break;

		pNodeNames->Nodes[x].pName = pText;

		while (isNameChar(*pText))
		{
			pNodeNames->Nodes[x].length++;
			pText++;
		}

		pNodeNames->count++;
	}

	return pNodeNames->count;
}

//--------------------------------------------------------------------------------
//
	int									// 0 = match
	CSXDB::SearchNodeNames
	(
		CSXDB_Node *pNode,				// The node to check
		NODE_NAMES *pNodeNames			// Ptr to the node names struct
	)
//
//	Parses a list of node names
//
//------------------------------------------------------------------------------//
{
	CSXDB_Attribute	pAttr;
	CSXDB_Element	pElem;
	int				x;
	int				type;
	int				length;

	if (pNodeNames->count == -1)
	{
		// Match all
		return 0;
	}

	type = pNode->GetType();
	length = strlen(pNode->GetName());

	for (x=0;x<pNodeNames->count;x++)
	{
		if (type == pNodeNames->Nodes[x].type && length == pNodeNames->Nodes[x].length)
		{
			if (strncmp(pNode->GetName(),pNodeNames->Nodes[x].pName, length ) == 0)
				return 0;
		}
	}

	return -1;
}

//--------------------------------------------------------------------------------
//
	CSXDB_Node *						// NULL if not found, else node ptr
	SXDB_FindAnsestor
	(
		const char		*	pName,			// The name we are searching for
		CSXDB_Node *	pChild,			// NULL to find the first, or the last found for next
		int				self			//  0 = Start at child->Parent()
										// !0 = Start at child
	)
//
//	Searches all of the ansestors of a node for one with the <pName.
//
//------------------------------------------------------------------------------//
{
	if (self)
	{
		if (pChild->GetName() != NULL)
		{
			if (strcmp(pName,pChild->GetName()) == 0)
				return pChild;
		}
	}

	if (pChild != NULL)
	{
		while ( (pChild = pChild->Parent()) != NULL )
		{
			if (pChild->GetName() != NULL)
			{
				if (strcmp(pName,pChild->GetName()) == 0)
					break;
			}
		}
	}

	return pChild;
}

