/*-------------------------------------------------------------------------------

	SXML_Out.cpp

	Copyright (c) 2002, Raritan Computer, Inc.

	XML Output functions

--------------------------------------------------------------------------------*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	"pp/SXML_Out.h"
#include	"pp/SXML_Errors.h"

//----------------------------------------
//				Equates
//----------------------------------------

#define	SXO_MAX_BUFFER		40

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Code
//----------------------------------------

//--------------------------------------------------------------------------------
//
	int									// posix error
	SXMLOut
	(
		CSIO	*	pOut,				// Output stream
		const char	*	pData				// The data to output
	)
//
//	Outputs XML data, escaping special characters
//
//------------------------------------------------------------------------------//
{
	int		result = 0;
	int		x;
	char	buffer[SXO_MAX_BUFFER];

	if (pData == NULL)
		return 0;

	while (*pData)
	{
		for (x=0;x<SXO_MAX_BUFFER-6 && *pData;pData++, x++)
		{
			switch (*pData)
			{
				case '>':
					buffer[x++] = '&';
					buffer[x++] = 'g';
					buffer[x++] = 't';
					buffer[x  ] = ';';
					break;

				case '<':
					buffer[x++] = '&';
					buffer[x++] = 'l';
					buffer[x++] = 't';
					buffer[x  ] = ';';
					break;
					
				case '&':
					buffer[x++] = '&';
					buffer[x++] = 'a';
					buffer[x++] = 'm';
					buffer[x++] = 'p';
					buffer[x  ] = ';';
					break;
					
				case 39:
					buffer[x++] = '&';
					buffer[x++] = 'a';
					buffer[x++] = 'p';
					buffer[x++] = 'o';
					buffer[x++] = 's';
					buffer[x  ] = ';';
					break;
					
				case 34:
					buffer[x++] = '&';
					buffer[x++] = 'q';
					buffer[x++] = 'u';
					buffer[x++] = 'o';
					buffer[x++] = 't';
					buffer[x  ] = ';';
					break;

				default:
					buffer[x] = *pData;
			}
		}

		result = pOut->Write(buffer,x);

		if (result < 0)
			break;
	}
					
	return result;
}

//--------------------------------------------------------------------------------
//
	int									// # of bytes output
	SXMLOut
	(
		char	*	pOut,				// Output string
		const char	*	pData,				// The data to output
		int			maxLength			// Max # of bytes to output (including NULL)
	)
//
//	Outputs XML data, escaping special characters
//
//------------------------------------------------------------------------------//
{
	int		count = 0;
	int		x;

	if (pData == NULL)
		goto EXIT;

	while (*pData)
	{
		for (x=0;count < maxLength-1 && *pData;pData++, x++)
		{
			switch (*pData)
			{
				case '>':
					if (count+4 >= maxLength)
						goto EXIT;
					*pOut++ = '&';
					*pOut++ = 'g';
					*pOut++ = 't';
					*pOut++ = ';';
					count += 4;
					break;

				case '<':
					if (count+4 >= maxLength)
						goto EXIT;
					*pOut++ = '&';
					*pOut++ = 'l';
					*pOut++ = 't';
					*pOut++ = ';';
					count += 4;
					break;
					
				case '&':
					if (count+5 >= maxLength)
						goto EXIT;
					*pOut++ = '&';
					*pOut++ = 'a';
					*pOut++ = 'm';
					*pOut++ = 'p';
					*pOut++ = ';';
					count += 5;
					break;
					
				case 39:
					if (count+6 >= maxLength)
						goto EXIT;
					*pOut++ = '&';
					*pOut++ = 'a';
					*pOut++ = 'p';
					*pOut++ = 'o';
					*pOut++ = 's';
					*pOut++ = ';';
					count += 6;
					break;
					
				case 34:
					if (count+6 >= maxLength)
						goto EXIT;
					*pOut++ = '&';
					*pOut++ = 'q';
					*pOut++ = 'u';
					*pOut++ = 'o';
					*pOut++ = 't';
					*pOut++ = ';';
					count += 6;
					break;

				default:
					*pOut++ = *pData;
					count++;
					break;
			}
		}
	}

EXIT:
	*pOut = 0;
					
	return count;
}
