/*-------------------------------------------------------------------------------

	Hash32.cpp

	Copyright (c) 2003, Raritan Computer, Inc.

	Utility function to create a 32-bit (int) hash code for given data.

--------------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include "pp/Hash32.h"

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Code
//----------------------------------------

//--------------------------------------------------------------------------------
//
	int
	Hash32
	(
		int		seed,					// Hash code starting point
		const char *	pData,					// Ptr to data
		int		length					// # of chars in data
	)
//
//	Creates a 32-bit (int) hash code for the given data. "seed" should be 0 except
//	when the caller is creating a hash code for several pieces of data. In that
//	case, seed will be the output of last call to Hash32.
//
//------------------------------------------------------------------------------//
{
	int		x,y,z;

	for (x=0;x<length;x++)
	{
		y = seed & 0x80000000;
		seed = (seed << 1) | ((y ? 0 : 1) ^ (seed & 0x2000 ? 0 : 1));
		z = (int) *pData++;
		seed = seed ^ (z | (z<<17));
	}

	return seed;
}

//--------------------------------------------------------------------------------
//
	int
	Hash32
	(
		int		seed,					// Hash code starting point
		const char *	pString					// Ptr to null terminated string
	)
//
//	Creates a 32-bit (int) hash code for the given data. "seed" should be 0 except
//	when the caller is creating a hash code for several pieces of data. In that
//	case, seed will be the output of last call to Hash32.
//
//------------------------------------------------------------------------------//
{
	return Hash32( seed, pString, strlen(pString) );
}

