
/*
 * shared memory allocation and management
 *
 * (c) 2004 Peppercon AG
 * tbr@peppercon.de
 */

#ifndef __PP_SHM_H__
#define __PP_SHM_H__

#include <sys/ipc.h>
#include <stdarg.h>
#include <pp/mallocator.h>

/*
 * some arbitrary key, we'll randomly choose one
 */
#define PP_SHM_KEY       0x77

/*
 * linux heap starts usually at 128MB
 * so we leave a little space for our 32MB RAM
 * and hope address at 512MB will be always available in all processes
 */
#define PP_SHM_VIRTADDR  (void*)(512 * 1024 * 1024)

/*
 * this is the actual type of the shared memory allocator
 */
typedef struct pp_shm_s pp_shm_t;

typedef int (*pp_shm_init_fkt)(void* idxmap[], pp_mallocator_t* a, va_list ap);

pp_shm_t* pp_shm_init(key_t shmkey, size_t shmsize, size_t idxmap_size, 
		      pp_shm_init_fkt init_fkt, ...);

void pp_shm_cleanup(pp_shm_t* shm);

void pp_shm_destroy(key_t shmkey);

void* pp_shm_get_obj(pp_shm_t* shm, unsigned long idx);

pp_shm_t* pp_shm_get(key_t shmkey);

/*
 * returns the key of this shared memory
 */
int pp_shm_get_key(pp_shm_t* shm);


/*
 * adds a semophore to the list of managed semaphores by
 * this shared memory
 */
void pp_shm_add_sem(pp_shm_t* shm, int semid);

/*
 * removes a semaphore from the list of managed semaphores
 * by this shared memory
 */
void pp_shm_remove_sem(pp_shm_t* shm, int semid);

#endif /* __PP_SHM_H__ */

