#ifndef _PP_STRSTREAM_H
#define _PP_STRSTREAM_H

#include <pp/win32.h>
#include <stdarg.h>

typedef struct pp_strstream_s {
    int on_heap;
    char* buf;
    size_t buflen;
    size_t pos;
} pp_strstream_t;

#define PP_STRSTREAM_INITIALIZER { 0, NULL, 0, 0 }

char* pp_dstrcat(char** buf, size_t* buflen, const char* str);
char* pp_dstrcpy(char** pBuf, size_t* pBufLen, size_t pos,
		 const char* str, size_t *ncpy);
char* pp_dstrncpy(char** pBuf, size_t* pBufLen, size_t pos,
		  const char* str, size_t n);
void* pp_dstrwrite(char** pBuf, size_t* pBufLen, size_t pos, const char* data, size_t len);
int pp_dchrcpy(char** pBuf, size_t* pBufLen, size_t pos, char chr);
int pp_dsprintf(char** buf, size_t* buflen, size_t pos,
		const char *format, ...);
int pp_dvsprintf(char** buf, size_t* buflen, size_t pos,
		 const char *format, va_list ap);
int pp_strappend(pp_strstream_t* stream, const char* str);
int pp_strappendn(pp_strstream_t* stream, const char* str, size_t n);
int pp_strappendf(pp_strstream_t* stream, const char* format, ...)
#ifndef _WIN32
    __attribute__ ((format (printf, 2, 3)))
#endif
    ;
int pp_vstrappendf(pp_strstream_t* stream, const char* format, va_list args);
int pp_strwrite(pp_strstream_t* stream, const char* data, size_t n);
char* pp_strstream_buf(pp_strstream_t* stream);
pp_strstream_t* pp_strstream_init(pp_strstream_t* stream);
void pp_strstream_free(pp_strstream_t* stream);
char* pp_strstream_buf_and_free(pp_strstream_t* stream);

// ATTENTION: pp_strappendchr does not append a trailing '\0'!!!
int pp_strappendchr(pp_strstream_t* stream, char chr);

static inline void pp_strstream_reset(pp_strstream_t* stream)
{
    stream->pos = 0;
}

static inline int pp_strstream_pos(pp_strstream_t* stream)
{
    return stream->pos;
}

static inline void pp_strstream_seek(pp_strstream_t* stream, unsigned int pos)
{
    stream->pos = pos;
}

// some funny encoding and decoding things, so you can use
// a tokenizer without taking care of the delimitters
void pp_strencode(const char* delis, pp_strstream_t* ostream, const char* s);
void pp_strdecode(const char* delis, pp_strstream_t* ostream, const char* s);

#endif /* _PP_STRSTREAM_H */
