/**
 * Copyright 2005 Peppercon AG
 * Author: Thomas Breitfeld <thomas@peppercon.de>
 *
 * Description: contains routines to control a serial
 *              line terminal more easily
 *              mainly intended for kme code
 */

#ifndef _PP_TERMIOS_H
#define _PP_TERMIOS_H

/*
 * Set baudrate, parity and number of bits.
 * @param fd     the tty file descriptor
 * @param baudr  the rate in baud pro second
 * @param par    the parity "E" - even
 *                          "O" - odd
 *                          ""  - no parity switched on 
 * @param bits   number of bits, directly given decimal
 * @param stob2  if true, 2 stop bits will be sent, otherwise 1
 * @param hwf    if true, hardware handshake will be enabled
 * @param swf    if true, software handshake will be enabled
 * @return -1 in case of error, errno will be set
 *         > 0 otherwise
 */
int pp_base_set_tty_params(int fd, int baudr, const char* par, 
			   int bits, int stop2, int hwf, int swf);

#define TTY_BREAK_IGNORE        1 // ignore incoming BREAKs (default)
#define TTY_BREAK_AS_SIGNAL     2 // send SIGINT
#define TTY_BREAK_AS_NULL_CHAR  3 // read BREAK as '\0'
#define TTY_BREAK_AS_SEQUENCE   4 // read BREAK as '\337''\0''\0'

/*
 * Set baudrate, parity and number of bits.
 * @param fd     the tty file descriptor
 * @param baudr  the rate in baud pro second
 * @param par    the parity "E" - even
 *                          "O" - odd
 *                          ""  - no parity switched on 
 * @param bits   number of bits, directly given decimal
 * @param stob2  if true, 2 stop bits will be sent, otherwise 1
 * @param hwf    if true, hardware handshake will be enabled
 * @param swf    if true, software handshake will be enabled
 * @param local  if true, CLOCAL control flag will be set
 * @param ttybrk set BREAK behavior (see TTY_BREAK_xxx)
 * @return -1 in case of error, errno will be set
 *         > 0 otherwise
 */
int pp_base_set_tty_params_ex(int fd, int baudr, const char* par, 
			      int bits, int stop2, int hwf, int swf,
			      int local, int ttybrk);


#endif /* _PP_TERMIOS_H */
