#ifndef _PP_TIMERQ_H
#define _PP_TIMERQ_H

#ifdef __cplusplus
extern "C" {
#endif

#if defined(PP_FEAT_DEVICE)

#include <pthread.h>
#include <pp/base.h>

typedef int (*pp_timerq_cb)(void *ctx);

typedef enum {
    NEW,
    SLEEPING,
    RUNNING,
    DESTROY
} pp_timerq_state_t;

typedef struct {
    pthread_mutex_t     mtx;
    pthread_cond_t      cond;
    pp_timerq_state_t   state;
    pp_queue_t*         queue;
    unsigned int        basetime;
} pp_timerq_t;

/* lifecycle */
pp_timerq_t* pp_timerq_create(void);
int pp_timerq_start(pp_timerq_t *tq);
int pp_timerq_stop(pp_timerq_t *tq);
void pp_timerq_destroy(pp_timerq_t *tq);

/* API */
int pp_timerq_add(pp_timerq_t *tq, unsigned int timeout,
                  pp_timerq_cb cb, void *ctx);
int pp_timerq_rem(pp_timerq_t *tq, unsigned int id);
int pp_timerq_empty(pp_timerq_t *tq);

#endif /* PP_FEAT_DEVICE */

#ifdef __cplusplus
}
#endif

#endif /* _PP_TIMERQ_H */
