/**
 * Copyright 2001 Peppercon AG
 * Author: Thomas Breitfeld <thomas@peppercon.de>
 *
 * Description: little string tokenizer for parsing
 *              strings
 */

#ifndef _PP_TOKENIZER_H
#define _PP_TOKENIZER_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
    const char* delis; // delemitters to search for 
    char* next;  // next available token
    char cdeli;  // save character
    int ondeli;  // current pos is on a deli 
    int skipdeli;// skip delis or not
} tokenizer_t;

#define TOKENIZER_DELI_RET 1    // return delis as tokens
#define TOKENIZER_DELI_NORET 0  // don't return delis as tokens

/*
 * initializes a new tokenizer structure
 * the string given to the tokenizer is going
 * to be destroyed by it. Means the tokenizer
 * is not allocating new memory for the Tokens
 * returned by the Tokenizer
 * There might be multiple delemitters, all given
 * in the single string delis
 * The retdeli boolean defines, whether delemiters are
 * also returned as tokens or not
 */
tokenizer_t* tokenizer_new(tokenizer_t* tok,
			   char* string, const char* delis, int retdeli);

/*
 * checks whether there anothter token available
 */
int tokenizer_has_next(tokenizer_t* tok);

/*
 * get next token from the tokenizer overgiven to
 * the function
 */
char* tokenizer_get_next(tokenizer_t* tok);

#ifdef __cplusplus
}
#endif

#endif /* _PP_TOKENIZER_H */
