/**
 * Copyright 2002 Peppercon AG
 * Author: Thomas Breitfeld <thomas@peppercon.de>
 *
 * Description: character encoding conversion routines
 */

#ifndef __PP_UTF_H
#define __PP_UTF_H

/*
 * converts an pur ASCII or any 8 bit Latin code string to its
 * UTF-8 counterpart.
 * The returned buffer will be newly allocated with malloc and is
 * supposed to be freed by the caller using free.
 * If the 2*length_of_latin_str+1 exceeds 2^16 NULL will be
 * returned and errno is set to EINVAL.
 */
extern char * pp_latin_to_utf8(const char * str, size_t * new_length);

/*
 * converts an UTF-8 (only 2-byte encodings) to a ASCII/Latin code
 * string.
 * The returned buffer will be newly allocated with malloc and is
 * supposed to be freed by the caller using free.
 */
extern char * pp_utf8_to_latin(const char * str, size_t * new_length);

#endif /* __PP_UTF_H */
