/*
 * simple standalone test for the dict, 
 * just in case, since its not our code
 *
 * compile: cc -Wall -Iinclude simple_dict_test.c rb_tree.c -o dict_test
 * run:     valgrind --leak-check=yes ./dict_test
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <sys/time.h>
#include <pp/dict.h>

static struct timeval start_time;
static struct timeval stop_time;

inline static void start() {
  gettimeofday(&start_time, NULL);
}

inline static void stop() {
  unsigned s, ms;
  gettimeofday(&stop_time, NULL);
  s = stop_time.tv_sec - start_time.tv_sec;
  if (stop_time.tv_usec < start_time.tv_usec) {
    --s;
    stop_time.tv_usec += 1000000;
  }
  ms = stop_time.tv_usec - start_time.tv_usec;
  printf("took... %d.%ds\n", s, ms);
}


#define STRING_LOOP_BEGIN                          \
    start();                                       \
  for (c1 = '0'; c1 <= 'z'; ++c1) {		   \
	for (c2 = 'z'; c2 >= '0'; --c2) {          \
	    for (c3 = '0'; c3 <= 'z'; ++c3) {      \
	        b[0] = b[1] = b[2] = b[3] = c1;    \
	        b[4] = b[5] = b[6] = b[7] = c2;    \
	        b[8] = b[9] = b[10] = b[11] = c3;  \
	        b[12] = '\0';

#define STRING_LOOP_END	} } } stop();
	    

int main(int argc, char** argv) {

    char b[64], *v;
    const char* k;
    unsigned char c1, c2, c3;
    pp_ditr_t* ditr;

    pp_dict_t* d = pp_dict_new((pp_dict_cmp_func)strcmp,
			       (pp_dict_dup_func)strdup,
			       free);

    printf("inserting...\n");

    STRING_LOOP_BEGIN;
    if(0 != pp_dict_insert(d, b, strdup(b), free, 0)) {
	printf("error: can't insert %s->%s\n", b, b);
    }
    STRING_LOOP_END;

    printf("%d entries in tree\n", pp_dict_count(d));

    printf("checking...\n");

    STRING_LOOP_BEGIN;
    v = pp_rb_tree_search(d, b);
    if (strcmp(b, v)) {
	printf("error: wrong lookup %s->%s\n", b, v);
    }
    STRING_LOOP_END;

    printf("iterating... \n");
    start();
    ditr = pp_ditr_new(d);
    for(pp_ditr_first(ditr); pp_ditr_valid(ditr); pp_ditr_next(ditr))
	if (strcmp(k = pp_ditr_key(ditr), v = pp_ditr_data(ditr)))
	    printf("error: wrong pair %s->%s\n", k, v);
    stop();

    printf("removeing...\n");

    STRING_LOOP_BEGIN;
    if (0 != pp_rb_tree_remove(d, b, NULL)) {
	printf("error: can't remove %s\n", b);
    }
    STRING_LOOP_END;

    printf("%d entries in tree\n", pp_dict_count(d));

    pp_dict_destroy(d);

    return 0;
}
