/**
 * Copyright 2003 Peppercon AG
 * Author: Thomas Breitfeld <thomas@peppercon.de>
 *
 * Description: url encoding and decoding routines
 */

#include <stdlib.h>
#include <string.h>
#include <pp/url.h>

char* pp_url_encode(char * s) {
    
    static unsigned char hexchars[] = "0123456789ABCDEF";
    size_t s_len = 0;
    unsigned int x, y;
    unsigned char * s_enc;

    if (s == NULL) { return NULL; }

    s_len = strlen(s);

    if ((s_enc = (unsigned char *) malloc(3 * s_len + 1)) != NULL) {
        for (x = 0, y = 0; s_len--; x++, y++) {
            if (s[x] == ' ') {
                s_enc[y] = '+';
            } else if ((s[x] < '0' && s[x] != '-' && s[x] != '.') ||
                       (s[x] < 'A' && s[x] > '9') ||
                       (s[x] > 'Z' && s[x] < 'a' && s[x] != '_') ||
                       (s[x] > 'z')) {
                s_enc[y++] = '%';
                s_enc[y++] = hexchars[(unsigned char) s[x] >> 4];
                s_enc[y] = hexchars[(unsigned char) s[x] & 15];
            } else {
                s_enc[y] = (unsigned char) s[x];
            }
        }
        s_enc[y] = '\0';
    }
    return ((char *)s_enc);
}
