#include <errno.h>
#include <openssl/bio.h>
#include <pp/bio.h>
#include <pp/features.h>

static BIO_METHOD methods_esb2_tpt = {
    .type = 0, // will be filled below (because can't use BIO_s_fd()-> here)
};

BIO_METHOD *
BIO_pp_esb2_tpt()
{
    if (methods_esb2_tpt.type == 0) {
        methods_esb2_tpt.type           = BIO_TYPE_PP_ESB2_TPT;
        methods_esb2_tpt.name           = "pp esb2 tpt";
        methods_esb2_tpt.bwrite         = BIO_s_fd()->bwrite;
        methods_esb2_tpt.bread          = BIO_s_fd()->bread;
        methods_esb2_tpt.bputs          = BIO_s_fd()->bputs;
        methods_esb2_tpt.bgets          = BIO_s_fd()->bgets;
        methods_esb2_tpt.ctrl           = BIO_s_fd()->ctrl;
        methods_esb2_tpt.create         = BIO_s_fd()->create;
        methods_esb2_tpt.destroy        = BIO_s_fd()->destroy;
        methods_esb2_tpt.callback_ctrl  = BIO_s_fd()->callback_ctrl;
    }
    return &methods_esb2_tpt;
}

BIO *
pp_bio_new_esb2_tpt(int fd, int close_flag)
{
    BIO *ret = BIO_new(BIO_pp_esb2_tpt());
    if (!ret) return NULL;
    BIO_set_fd(ret, fd, close_flag);
    return ret;
}
