#include <stdio.h>
#include <pp/cd.h>

#ifndef PP_BOARD_PEMX
#define PP_BOARD_PEMX
#endif

int main() {
    pp_cd_as_cd_t *src_cd_0, *src_cd_1, *src_cd_2;
    vector_t vs, *src_cds = &vs, *result;
    pp_mallocator_t *a = pp_mallocator_heap();
    u_int result_sz, u;
    pp_cd_cfg_key_desc_t *ckd;
    
    if (NULL == (src_cd_0 = pp_cd_parse_cdl(a, "src_cd_0.cdl")) ||
        NULL == (src_cd_1 = pp_cd_parse_cdl(a, "src_cd_1.cdl")) ||
        NULL == (src_cd_2 = pp_cd_parse_cdl(a, "src_cd_2.cdl"))) {
        printf("Error parsing cdls\n");
        return 1;
    }
    
    vector_new(src_cds, 5, pp_cd_destroy);
    vector_add(src_cds, src_cd_0);
    vector_add(src_cds, src_cd_1);
    vector_add(src_cds, src_cd_2);
    
    if(NULL != (result = pp_cd_union_cds(src_cds))) {
        result_sz = vector_size(result);
        for(u = 0; u < result_sz; ++u) {
            ckd = vector_get(result, u);
printf("\nckd[%u]:\n\n", u);
u_int u2;
printf("    %u qids\n", vector_size(ckd->qids));
//for(u2 = 0; u2 < vector_size(ckd->qids); ++u2) printf("     %u: %s\n", u2, (char*)vector_get(ckd->qids, u2));
        }
    }    
    
    vector_delete(src_cds);
    vector_delete(result);

    return 0;
}
