/*
 * The config library providing extension functions
 * that maybe used by the Layered profile manager which
 * is not part of that library
 *
 * (c) 2004 Peppercon AG
 * tbr@peppercon.de
 */

#include <pp/cfg.h>

#ifndef __PP_CFGX_H__
#define __PP_CFGX_H__

/*
 * profile type stack struct and initializer
 */
typedef struct {
    int                 size;
    pp_profile_type_t   profile_type_stack[PP_PROFILE_COUNT];
} pp_profile_type_stack_t;

#define PP_PROFILE_TYPE_STACK_T_INITIALIZER \
            { .size = 0, .profile_type_stack = {0, 0, 0, 0, 0, 0, 0} }
 
int pp_cfg_get_profile_type_stack(pp_profile_type_stack_t *prof_type_stack,
                                  pp_profile_type_t prof_type,
                                  const char* key, ...)
                                  __attribute__ ((format (printf, 3, 4)));
int pp_cfg_get_profile_type_stack_core(pp_profile_type_stack_t *prof_type_stack,
                                       pp_profile_type_t prof_type,
                                       const vector_t *key_comps);
int __pp_cfg_get_profile_type_stack_core(pp_profile_type_stack_t
                                         *prof_type_stack,
                                         pp_profile_type_t prof_type,
                                         const vector_t *key_comps);
int pp_cfg_get_profile_stack(vector_t** prof_stack,
			     pp_profile_type_t prof_type,
			     const char* key, ...)
                             __attribute__ ((format (printf, 3, 4)));
int pp_cfg_get_profile_stack_core(vector_t** prof_stack,
			          pp_profile_type_t prof_type,
			          const vector_t *key_comps);
int __pp_cfg_get_profile_stack_core(vector_t** prof_stack,
			            pp_profile_type_t prof_type,
			            const vector_t *key_comps);
int pp_cfg_get_profile(pp_profile_t** prof, pp_profile_type_t prof_type,
		       const char* key, va_list args);
int pp_cfg_get_profile_core(pp_profile_t** prof, pp_profile_type_t prof_type,
		            const vector_t *key_comps, int uid);
int __pp_cfg_get_profile_core(pp_profile_t** prof, pp_profile_type_t prof_type,
		              const vector_t *key_comps, int uid);


/*
 * TODO, need to implement some equivalents to this, somehow
 */
/* handle local profile tags */
#if 0
extern const char*  local_profile_tag_key;
extern const char*  ldap_profile_tag_key;

vector_t* pp_um_Principal_get_local_tags(const char* name, int* error);

char* pp_um_Principal_get_current_tag(const char* name, int* error);

int pp_um_Principal_is_current_tag(const char* name, const char* tag,
				       int* error);

int pp_um_Principal_create_local_tag(const char* name, const char* tagname,
				       int* error);

int pp_um_Principal_delete_local_tag(const char* name, const char* tagname,
				       int* error);
#endif

// get some info about a currently active profile 
typedef struct {
    char* local_tag;
    int   ldap_prof_is_active;
    char* ldap_requested_tag;
    char* ldap_active_tag;
    char* ldap_profile_name;
    int   ldap_error;
} pp_cfg_profile_info_t;

/**
 * replaces eric_um_get_profile_info
 */
int pp_cfg_get_profile_info(pp_cfg_profile_info_t** pi, int uid);

/**
 * replaces eric_um_get_profile_info
 */
int pp_cfg_profile_info_destroy(pp_cfg_profile_info_t* pi);

#endif
