/**
 * Profile cache manages loading of profiles
 * from the local file system if necessary
 *
 * (c) 2004 Peppercon AG
 * tbr@peppercon.de>
 */

#ifndef __PP_PROFILE_CACHE_H__
#define __PP_PROFILE_CACHE_H__

#include <pp/profile.h>

typedef struct pp_profile_cache_s pp_profile_cache_t;
typedef pp_profile_t*(*pp_profile_cache_load_fkt)(pp_profile_type_t, const char*);
typedef int(*pp_profile_cache_diff_fkt)(pp_profile_t*, pp_profile_t*);

pp_profile_cache_t* pp_profile_cache_create(pp_profile_cache_load_fkt load,
                                            pp_profile_cache_diff_fkt diff);
void pp_profile_cache_destroy(pp_profile_cache_t* pc);

pp_profile_t* pp_profile_cache_load(pp_profile_cache_t* pc, pp_profile_type_t type, 
                                    const char* fname);

int profile_cache_update_timestamp(pp_profile_cache_t* pc, 
                                   pp_profile_type_t type,
                                   const char* fname);


#endif
