/*
 * standalone cdl parser's main function
 *
 * (c) 2004 Peppercon AG
 * tbr@peppercon.de
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pp/cfg.h>
#include <liberic_config.h>

#define GET_CFG(key, args...)                        \
    { char *v = NULL; int r;                         \
      if(0 == (r = pp_cfg_get(&v, key, ##args)))     \
	printf("%s -> %s\n", key, v);                \
      else                                           \
	printf("%s -> error %d, %s!!\n", key, r, v); \
      free(v);                                       \
    }

static int cfg_chg_cb_0(pp_cfg_chg_ctx_t *ctx) {
    printf("cfg_chg_cb_0 fired %d\n", ctx->chg_kind);
    return 0;
}
static int cfg_chg_cb_1(pp_cfg_chg_ctx_t *ctx) {
    printf("cfg_chg_cb_1 fired %d\n", ctx->chg_kind);
    return 0;
}
static int cfg_chg_cb_2(pp_cfg_chg_ctx_t *ctx) {
    printf("cfg_chg_cb_2 fired %d\n", ctx->chg_kind);
    return 0;
}
static int cfg_chg_cb_3(pp_cfg_chg_ctx_t *ctx) {
    printf("cfg_chg_cb_3 fired %d\n", ctx->chg_kind);
    return 0;
}
static int cfg_chg_cb_4(pp_cfg_chg_ctx_t *ctx) {
    printf("cfg_chg_cb_4 fired %d, sleeping one second\n", ctx->chg_kind);
    sleep(1);
    return 0;
}
static int cfg_chg_cb_5(pp_cfg_chg_ctx_t *ctx) {
    char *val;
    pp_cfg_get(&val, "user[ron].name");
    printf("cfg_chg_cb_5 fired %d, user[ron].name = '%s'\n", ctx->chg_kind, val);
    free(val);
    return 0;
}

int main (int argc, char** argv) {
    pp_cfg_tx_t* tx;
    char *val;
    const char *val_c;
    
    if (argc > 1 && *argv[1] == 'c') {
	pp_cfg_destroy();
	return 0;
    }

    eric_config_init(FLUSH_IN_BACKGROUND);
    if (PP_ERR == pp_cfg_init("base.cdl", NULL)) abort();

    GET_CFG("network.ipaddr");
    GET_CFG("network.netmask");
    GET_CFG("user[thomas].uid");
    GET_CFG("user[%s].uid", "thomas");
    GET_CFG("user[%s].uid", "thoma");
    GET_CFG("user[%s].rc.hotkey[%u].key", "thomas", 10);
    GET_CFG("user[%s].rc.hotkey[%u].key", "thomas", 11);
    
    GET_CFG("user[super].uid");
    GET_CFG("user[super].pw_hash");
    GET_CFG("user[super].name");
    GET_CFG("user[super].rc.hotkey[0].key");
    GET_CFG("user[super].rc.hotkey.key");
    GET_CFG("user.rc.hotkey.key");
    GET_CFG("user[thomas][0]");

    printf("testing cfg validate and set...\n");
    printf("setting correct key results %s\n", 
           pp_cfg_validate_and_set_int(7, "serial") == PP_ERR ?
           "PP_ERR" : "PP_SUC");
    printf("setting wrong key results %s\n", 
           pp_cfg_validate_and_set("just a test", "serial") == PP_ERR ?
           "PP_ERR" : "PP_SUC");

    printf("testing notifications... \n");
    // check notifications
    pp_cfg_add_change_listener(cfg_chg_cb_0, "user[%s].rc.hotkey[%u].key",
			       "thomas", 10);
    pp_cfg_add_change_listener(cfg_chg_cb_1, "user[%s]", "thomas");
    pp_cfg_add_change_listener(cfg_chg_cb_0, "user[%s]", "thomas");
    pp_cfg_add_change_listener(cfg_chg_cb_3, "user[%s]", "thomas");
    pp_cfg_add_change_listener(cfg_chg_cb_2, "user.rc.hotkey.key");

    printf("expect 0 1 3\n");
    pp_cfg_set("bla", "user[%s].rc.hotkey[%u].key", "thomas", 10);
    usleep(10000);
    printf("expect 0 1 3\n");
    pp_cfg_set("111", "user[%s].uid", "thomas");
    usleep(10000);
    printf("expect 2\n");
    pp_cfg_set("blo", "user.rc.hotkey.key");
    usleep(10000);
    printf("expect nothing\n");
    pp_cfg_set("blu", "user[ron].name");
    usleep(10000);

    pp_cfg_rem_change_listener(cfg_chg_cb_1, "user[thomas]");
    printf("removed listener cfg_chg_cb_1:user[thomas]\n");
    printf("expect 0 3\n");
    pp_cfg_set("bla", "user[%s].rc.hotkey[%u].key", "thomas", 10);
    usleep(10000);
    
    pp_cfg_rem_change_listener(NULL, "user[thomas]");
    printf("removed all listeners for user[thomas]\n");
    printf("expect 0\n");
    pp_cfg_set("bla", "user[%s].rc.hotkey[%u].key", "thomas", 10);
    usleep(10000);
    printf("end of notifications\n");

    pp_cfg_rem_change_listener(cfg_chg_cb_2, "user.rc.hotkey.key");

    // check transactions
    pp_cfg_add_change_listener(cfg_chg_cb_4, "user[%s]", "thomas");
    pp_cfg_add_post_tx_change_listener(cfg_chg_cb_2, "user[%s]", "thomas");
    pp_cfg_add_change_listener(cfg_chg_cb_1, "user[%s]", "thomas");
    pp_cfg_add_change_listener(cfg_chg_cb_0, "user[%s]", "thomas");
    pp_cfg_add_change_listener(cfg_chg_cb_3, "user[%s]", "thomas");
    pp_cfg_add_change_listener(cfg_chg_cb_5, "user[ron].name");
    
    tx = pp_cfg_tx_begin(1);
    pp_cfg_set("111", "user[%s].rc.hotkey[%u].key", "thomas", 10);
    pp_cfg_set("222", "user[%s].uid", "thomas");
    pp_cfg_set("333", "user.rc.hotkey.key");

    printf("test pp_cfg_get: user[ron].name, should be 'blu'\n");
    if(PP_ERR == pp_cfg_get(&val, "user[ron].name")) {
        printf("ERROR: this should not happen\n");
        abort();
    } else {
        printf("succeeded: got '%s'\n", val);
    }
    free(val);
    
    pp_cfg_set("444", "user[ron].name");
    
    printf("test pp_cfg_get: user[ron].name, should be '444'\n");
    if(PP_ERR == pp_cfg_get(&val, "user[ron].name")) {
        printf("ERROR: this should not happen\n");
        abort();
    } else {
        printf("succeeded: got '%s'\n", val);
    }
    free(val);
    
    printf("committed, expecting 4 1 0 3 5 ... 2\n");
//    pp_cfg_tx_commit(tx);
    pp_cfg_tx_commit_core(tx, DO_FLUSH, 1, 1, NULL);
    usleep(10000);
    
    printf("testing change handlers discarding untouched variables\n");
    pp_cfg_set("discard", "user[ron].name");
    printf("set user[ron].name to 'discard', expecting 5\n");
    usleep(10000);
    pp_cfg_set("discard", "user[ron].name");
    printf("set user[ron].name to 'discard', expecting nothing\n");
    usleep(10000);
    
    pp_cfg_rem_change_listener(cfg_chg_cb_4, "user[%s]", "thomas");
    pp_cfg_rem_change_listener(cfg_chg_cb_2, "user[%s]", "thomas");
    
    GET_CFG("user[%s].rc.hotkey[%u].key", "thomas", 10);
    GET_CFG("user[%s].uid", "thomas");
    GET_CFG("user.rc.hotkey.key");

    printf("validate LOCAL profile: %s\n", 
           pp_profile_validate_type(PP_PROFILE_LOCAL) == PP_SUC ?
           "SUCCESS" : "ERROR");

    // check special vector operations
    printf("testing vector size operation... \n");
    pp_cfg_set("6", "user[%s].rc.hotkey._s_", "thomas");
    usleep(10000);

    printf("validate LOCAL profile: %s\n", 
           pp_profile_validate_type(PP_PROFILE_LOCAL) == PP_SUC ?
           "SUCCESS" : "ERROR");

    GET_CFG("user[%s].rc.hotkey[%u].key", "thomas", 10);
    GET_CFG("user[%s].rc.hotkey._s_", "thomas");
    
    printf("testing wildcard notification...\n");
    pp_cfg_add_change_listener(cfg_chg_cb_1, "user[?].rc.mousesync.key");
    printf("expect 1\n");
    pp_cfg_set("ctrl+alt+m", "user[%s].rc.mousesync.key", "tweb");
    usleep(10000);
    printf("expect 0 1 3\n");
    pp_cfg_set("ctrl+alt+m", "user[%s].rc.mousesync.key", "thomas");
    pp_cfg_rem_change_listener(cfg_chg_cb_1, "user[?].rc.mousesync.key");
    usleep(10000);
    printf("expect nothing\n");
    pp_cfg_set("ctrl+alt+m", "user[%s].rc.mousesync.key", "tweb");
    
    printf("testing rename...\n");
    pp_cfg_rename("alternative", "user[%s]", "thomas");

    printf("testing copy...\n");
    pp_cfg_copy("user[thomas]", "user[%s]", "alternative");

    printf("testing remove...\n");
    pp_cfg_remove("user[%s]", "alternative");                                   
    printf("validate LOCAL profile: %s\n", 
           pp_profile_validate_type(PP_PROFILE_LOCAL) == PP_SUC ?
           "SUCCESS" : "ERROR");

    printf("test flusher\nflush once...\n");
    pp_cfg_save(DO_FLUSH);
    printf("... and again...\n");
    pp_cfg_save(DO_FLUSH);
    printf("... and again...\n");
    pp_cfg_save(DO_FLUSH);

    printf("testing property reception...\n");
    pp_cfg_get_perm(&val_c, "unit[%u].port[%u].mouse.mode", 0, 7);
    printf("got perm '%s' for unit[0].port[7].mouse.mode\n", val_c);
    pp_cfg_get_prop(&val_c, "desc", "unit[%u].port[%u].mouse.mode", 0, 7);
    printf("got description '%s' for unit[0].port[7].mouse.mode\n", val_c);

    printf("cfg test done, cleaning up\n");

    pp_cfg_cleanup();
    eric_config_cleanup();
    return 0;
}

