#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_admin.h"

// forward declarations
static char *admin_clp_help_instance(pp_cim_instance_t *instance,
    int verbose);
static char *admin_clp_help_class(pp_cim_class_t *cim_class, int verbose);

// provider API functions
static pp_cim_provider_t provider =
{
    .deinit = provider_common_deinit,
    .update = provider_common_update,
    .commit = provider_common_commit,
    .authorize = provider_common_authorize,
    .get_property = provider_common_get_property,
    .set_property = provider_common_set_property,
    .get_properties = provider_common_get_properties,
    .set_properties = provider_common_set_properties,
    .get_method = provider_common_get_method,
    .call_method = provider_common_call_method,
    .clp_map_reset = NULL, // 'reset' command not supported
    .clp_map_set = NULL, // 'set' command not supported
    .clp_map_start = NULL, // 'start' command not supported
    .clp_map_stop = NULL, // 'stop' command not supported
    .clp_help = admin_clp_help_instance
};

// class description
pp_cim_class_desc_t pp_cim_admindomain_desc =
{
    .cim_name = "CIM_AdminDomain",
    .ufct = "admin",
    .dispname = "CIM Admin Domain",
    .superclass = "CIM_System",
    .assoc = 0,
    .properties = NULL, // no properties
    .methods = NULL, // no methods
    .update = NULL,
    .clp_update = NULL,
    .clp_help = admin_clp_help_class
};

// Create a new CIM_AdminDomain instance
pp_cim_instance_t *pp_cim_admindomain_new()
{
    pp_cim_data_t d = {0, {.string_const = "Admin Domain"}};
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_AdminDomain", &provider);
    provider_common_set_property(i, "Name", d, 1);
    return i;
}

static const char clp_help_message[] =
    "The CIM_AdminDomain is the root of the CLP namespace. It does not support\r\n"
    "any special CLP operations.\r\n";

static char *admin_clp_help_instance(pp_cim_instance_t *instance UNUSED,
    int verbose UNUSED)
{
    return strdup(clp_help_message);
}

static char *admin_clp_help_class(pp_cim_class_t *cim_class UNUSED,
    int verbose UNUSED)
{
    return strdup(clp_help_message);
}

