/*
 * CIM_ChassisLocator class implementation
 *
 * Note: This class is not covered by any specification!
 */

#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include <pp/ipmi.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_chassislocator.h"

static pp_cim_method_call_t *map_set(pp_cim_instance_t *instance,
	pp_clp_property_value_t *prop);
static pp_cim_method_call_t *map_start(pp_cim_instance_t *instance);

static char *clp_help_instance(pp_cim_instance_t *instance, int verbose);
static char *clp_help_class(pp_cim_class_t *class, int verbose);

static int setinterval(pp_cim_instance_t *instance, vector_t *args,
    pp_cim_data_t *result);
static int enable(pp_cim_instance_t *instance, vector_t *args,
    pp_cim_data_t *result);

// provider API functions
static pp_cim_provider_t provider =
{
    .deinit = provider_common_deinit,
    .update = provider_common_update,
    .commit = provider_common_commit,
    .authorize = provider_common_authorize,
    .get_property = provider_common_get_property,
    .set_property = provider_common_set_property,
    .get_properties = provider_common_get_properties,
    .set_properties = provider_common_set_properties,
    .get_method = provider_common_get_method,
    .call_method = provider_common_call_method,
    .clp_map_reset = NULL, // 'reset' command not supported
    .clp_map_set = map_set,
    .clp_map_start = map_start,
    .clp_map_stop = NULL, // 'stop' command not supported
    .clp_help = clp_help_instance
};

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"Interval", PP_CIM_UNSIGNED, 0, NULL, 0, 0, 1, 1, {0, {.unsigned_int = 15}}},
    {.name = NULL}
};

// CIM_ChassisLocator::SetInterval() arguments
// { <name>, <type>, <array>, <valmap>, <in>, <out> }
static pp_cim_method_arg_t setinterval_args[] =
{
    {"Interval", PP_CIM_UNSIGNED, 0, NULL, 1, 0}
};

// class methods
// { <name>, <result>, <num_args>, <args>, <priv>, <defptr> }
static pp_cim_method_t methods[] =
{
    {"SetInterval", PP_CIM_VOID, 1, setinterval_args, 0, setinterval},
    {"Enable", PP_CIM_VOID, 0, NULL, 0, enable},
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_chassislocator_desc =
{
    .cim_name = "CIM_ChassisLocator",
    .dispname = "CIM Chassis Locator",
    .ufct = "locator",
    .superclass = "CIM_LogicalDevice",
    .assoc = 0,
    .properties = properties,
    .methods = methods,
    .update = NULL,
    .clp_update = NULL,
    .clp_help = clp_help_class
};

// Create a new PP_ChassisLocator instance
pp_cim_instance_t *pp_cim_chassislocator_new()
{
    pp_cim_data_t d = {0, {.string_const = "IPMI Chassis Identify"}};
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_ChassisLocator", &provider);
    provider_common_set_property(i, "DeviceID", d, 1);
    return i;
}

static pp_cim_method_call_t *map_set(pp_cim_instance_t *instance,
    pp_clp_property_value_t *prop)
{
    if (strcasecmp(prop->property, "Interval") == 0) {
	pp_cim_data_t *arg;
	pp_cim_methodptr_t *methodptr;
	pp_cim_method_call_t *call;
	int interval;
	char *ptr;

	if (!prop->value || prop->value[0] == '\0') return NULL;
	interval = strtol(prop->value, &ptr, 10);
	if (*ptr != '\0') return NULL;

	methodptr = instance->provider->get_method(instance, "SetInterval");
	call = pp_cim_method_call_new(methodptr, instance);
	arg = malloc(sizeof(pp_cim_data_t));
	arg->null = 0;
	arg->types.unsigned_int = interval;
	vector_add(call->args, arg);
	return call;
    }

    return NULL;
}

static pp_cim_method_call_t *map_start(pp_cim_instance_t *instance)
{
    pp_cim_methodptr_t *methodptr;
    pp_cim_method_call_t *call;

    methodptr = instance->provider->get_method(instance, "Enable");
    call = pp_cim_method_call_new(methodptr, instance);

    return call;
}

static const char clp_help_message[] =
    "The CIM_ChassisLocator class is used to cause a chassis to physically\r\n"
    "identify itself. It supports the following operations:\r\n"
    " - Setting the identify interval:   SET Interval=10\r\n"
    " - Assert the identify condition:   START\r\n";

static char *clp_help_instance(pp_cim_instance_t *instance UNUSED,
	int verbose UNUSED)
{
    return strdup(clp_help_message);
}

static char *clp_help_class(pp_cim_class_t *class UNUSED,
	int verbose UNUSED)
{
    return strdup(clp_help_message);
}

static int setinterval(pp_cim_instance_t *instance, vector_t *args,
    pp_cim_data_t *result UNUSED)
{
    pp_cim_data_t *arg;

    if (vector_size(args) != 1) return PP_ERR;
    arg = vector_get(args, 0);
    if (arg->types.unsigned_int > 255) arg->types.unsigned_int = 255;
    provider_common_set_property(instance, "Interval", *arg, 0);

    return PP_SUC;
}

static int enable(pp_cim_instance_t *instance, vector_t *args UNUSED,
    pp_cim_data_t *result UNUSED)
{
    int interval;
    pp_cim_propval_t *pv;
    pp_ipmi_parameter_t ipmi_param;
    int ret, err;

    pv = provider_common_get_property(instance, "Interval");
    interval = pv->data.types.unsigned_int;
    pp_cim_propval_delete(pv);

    memset(&ipmi_param, 0, sizeof(ipmi_param));
    ipmi_param.data.chassis_identify = interval;
    ret = pp_ipmi_send_command(PP_IPMI_CMD_CHASSIS,
	    PP_IPMI_CHASSIS_SUBCMD_IDENTIFY, &ipmi_param, NULL, &err, NULL);

    return PP_SUC;
}

