#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_component.h"

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"GroupComponent", PP_CIM_REFERENCE, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {"PartComponent", PP_CIM_REFERENCE, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_component_desc =
{
    .cim_name = "CIM_Component",
    .ufct = NULL,
    .dispname = "CIM Component",
    .superclass = NULL,
    .assoc = 1,
    .properties = properties,
    .methods = NULL, // no methods
    .update = NULL,
    .clp_update = NULL
};

// Create a new CIM_Component (or subclass) instance
pp_cim_instance_t *pp_cim_component_new(const char *cim_name,
    pp_cim_instance_t *group, pp_cim_instance_t *part)
{
    pp_cim_data_t d;
    pp_cim_instance_t *i = pp_cim_instance_new(cim_name, &provider_common);
    d.null = group ? 0 : 1;
    d.types.reference = group;
    provider_common_set_property(i, "GroupComponent", d, 1);
    d.null = part ? 0 : 1;
    d.types.reference = part;
    provider_common_set_property(i, "PartComponent", d, 1);
    return i;
}

