#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_coolingdevice.h"
#include "provider_logicaldevice.h"

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"ActiveCooling", PP_CIM_BOOLEAN, 0, NULL, 0, 0, 0, 0, {0, {.boolean = 1}}},
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_coolingdevice_desc =
{
    .cim_name = "CIM_CoolingDevice",
    .ufct = "cooling",
    .dispname = "CIM Cooling Device",
    .superclass = "CIM_LogicalDevice",
    .assoc = 0,
    .properties = properties,
    .methods = NULL, // no methods
    .update = NULL,
    .clp_update = NULL
};

// Create a new CIM_CoolingDevice instance
pp_cim_instance_t *pp_cim_coolingdevice_new()
{
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_CoolingDevice", &provider_common);
    return i;
}

