#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_dependency.h"

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"Antecedent", PP_CIM_REFERENCE, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {"Dependent", PP_CIM_REFERENCE, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_dependency_desc =
{
    .cim_name = "CIM_Dependency",
    .ufct = NULL,
    .dispname = "CIM Dependency",
    .superclass = NULL,
    .assoc = 1,
    .properties = properties,
    .methods = NULL, // no methods
    .update = NULL,
    .clp_update = NULL
};

// Create a new CIM_Dependency (or subclass) instance
pp_cim_instance_t *pp_cim_dependency_new(const char *cim_name,
    pp_cim_instance_t *antecedent, pp_cim_instance_t *dependent)
{
    pp_cim_data_t d;
    pp_cim_instance_t *i = pp_cim_instance_new(cim_name, &provider_common);
    d.null = antecedent ? 0 : 1;
    d.types.reference = antecedent;
    provider_common_set_property(i, "Antecedent", d, 1);
    d.null = dependent ? 0 : 1;
    d.types.reference = dependent;
    provider_common_set_property(i, "Dependent", d, 1);
    return i;
}

