/*
 * PP_Led class implementation
 *
 * Note: For demonstration purposes only, this class is not covered
 *       by any spec.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include <pp_gpio.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_led.h"

static void led_update(pp_cim_instance_t *instance);
static pp_cim_method_call_t *led_map_set(pp_cim_instance_t *instance,
    pp_clp_property_value_t *prop);
static int led_setenabled(pp_cim_instance_t *instance, vector_t *args,
    pp_cim_data_t *result);

// provider API functions
static pp_cim_provider_t provider =
{
    .deinit = provider_common_deinit,
    .update = led_update,
    .commit = provider_common_commit,
    .authorize = provider_common_authorize,
    .get_property = provider_common_get_property,
    .set_property = provider_common_set_property,
    .get_properties = provider_common_get_properties,
    .set_properties = provider_common_set_properties,
    .get_method = provider_common_get_method,
    .call_method = provider_common_call_method,
    .clp_map_reset = NULL, // 'reset' command not supported
    .clp_map_set = led_map_set,
    .clp_map_start = NULL, // 'start' command not supported
    .clp_map_stop = NULL // 'stop' command not supported
};

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"Name", PP_CIM_STRING_CONST, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {"Device", PP_CIM_STRING_CONST, 0, NULL, 0, 0, 1, 0, {0, {.string_const = "/dev/gpio0"}}},
    {"Bit", PP_CIM_UNSIGNED, 0, NULL, 0, 0, 1, 0, {0, {.unsigned_int = 8}}},
    {"Enabled", PP_CIM_BOOLEAN, 0, NULL, 0, 0, 1, 0, {1, {0}}},
    {.name = NULL}
};

// PP_Led::SetEnabled() arguments
// { <name>, <type>, <array>, <valmap>, <in>, <out> }
static pp_cim_method_arg_t led_setenabled_args[] =
{
    {"Enabled", PP_CIM_BOOLEAN, 0, NULL, 1, 0}
};

// class methods
// { <name>, <result>, <num_args>, <args>, <priv>, <defptr> }
static pp_cim_method_t methods[] =
{
    {"SetEnabled", PP_CIM_VOID, 1, led_setenabled_args, 0, led_setenabled},
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_pp_led_desc =
{
    .cim_name = "PP_Led",
    .dispname = "LED",
    .ufct = "led",
    .superclass = NULL,
    .assoc = 0,
    .properties = properties,
    .methods = methods,
    .update = NULL,
    .clp_update = NULL
};

// Create a new PP_Led instance
pp_cim_instance_t *pp_cim_led_new()
{
    pp_cim_instance_t *i = pp_cim_instance_new("PP_Led", &provider);
    return i;
}

vector_t *pp_cim_led_discovery()
{
    pp_cim_instance_t *inst;
    pp_cim_data_t name, device, bit;

    name.null = 0;
    device.null = 0;
    bit.null = 0;

    vector_t *result = vector_new(NULL, 4, NULL);

    device.types.string = strdup("/dev/gpio0");
    inst = pp_cim_led_new();
    name.types.string_const = "LED1";
    bit.types.unsigned_int = 8;
    provider_common_set_property(inst, "Name", name, 1);
    provider_common_set_property(inst, "Device", device, 1);
    provider_common_set_property(inst, "Bit", bit, 1);
    vector_add(result, inst);
    inst = pp_cim_led_new();
    name.types.string_const = "LED2";
    bit.types.unsigned_int = 13;
    provider_common_set_property(inst, "Name", name, 1);
    provider_common_set_property(inst, "Device", device, 1);
    provider_common_set_property(inst, "Bit", bit, 1);
    vector_add(result, inst);
    free(device.types.string);

    device.types.string = strdup("/dev/gpio1");
    inst = pp_cim_led_new();
    name.types.string_const = "LED3";
    bit.types.unsigned_int = 12;
    provider_common_set_property(inst, "Name", name, 1);
    provider_common_set_property(inst, "Device", device, 1);
    provider_common_set_property(inst, "Bit", bit, 1);
    vector_add(result, inst);
    inst = pp_cim_led_new();
    name.types.string_const = "LED4";
    bit.types.unsigned_int = 11;
    provider_common_set_property(inst, "Name", name, 1);
    provider_common_set_property(inst, "Device", device, 1);
    provider_common_set_property(inst, "Bit", bit, 1);
    vector_add(result, inst);
    free(device.types.string);

    return result;
}

static void led_update(pp_cim_instance_t *instance)
{
    pp_cim_propval_t *pv;
    int fd, bit;
    char *device;
    pp_cim_data_t data;

    provider_common_update(instance);

    pv = instance->provider->get_property(instance, "Bit");
    if (!pv || pv->data.null) {
        pp_cim_propval_delete(pv);
        return;
    }
    bit = pv->data.types.unsigned_int;
    pp_cim_propval_delete(pv);
    pv = instance->provider->get_property(instance, "Device");
    if (!pv || pv->data.null) {
        pp_cim_propval_delete(pv);
        return;
    }
    device = strdup(pv->data.types.string_const);
    pp_cim_propval_delete(pv);

    fd = open(device, O_RDWR);
    free(device);
    if (!fd)
        return;
    data.null = 0;
    data.types.boolean = gpio_ioctl_get_bit(fd, bit);
    close(fd);

    provider_common_set_property(instance, "Enabled", data, 1);
}

static pp_cim_method_call_t *led_map_set(pp_cim_instance_t *instance,
    pp_clp_property_value_t *prop)
{
    pp_cim_data_t *arg;
    pp_cim_methodptr_t *methodptr;
    pp_cim_method_call_t *call;

    if (strcasecmp(prop->property, "Enabled") == 0) {
        methodptr = provider_common_get_method(instance, "SetEnabled");
        call = pp_cim_method_call_new(methodptr, instance);
        arg = pp_cim_data_parse(call->methodptr->method->args[0].type, prop->value);
        if (!arg)
            return NULL;
        vector_add(call->args, arg);
        return call;
    }

    return NULL;
}

static int led_setenabled(pp_cim_instance_t *instance, vector_t *args,
    pp_cim_data_t *result UNUSED)
{
    pp_cim_data_t *arg;
    pp_cim_propval_t *pv;
    int fd, bit, enabled;
    char *device;
    instance = instance;
    if (vector_size(args) != 1)
        return PP_ERR;
    arg = vector_get(args, 0);
    enabled = arg->types.boolean;

    pv = pp_cim_get_property(instance, "Bit");
    if (!pv || pv->data.null) {
        pp_cim_propval_delete(pv);
        return PP_ERR;
    }
    bit = pv->data.types.unsigned_int;
    pp_cim_propval_delete(pv);
    pv = pp_cim_get_property(instance, "Device");
    if (!pv || pv->data.null) {
        pp_cim_propval_delete(pv);
        return PP_ERR;
    }
    device = strdup(pv->data.types.string_const);
    pp_cim_propval_delete(pv);

    fd = open(device, O_RDWR);
    if (!fd) {
        free(device);
        return PP_ERR;
    }
    gpio_ioctl_set_bit(fd, bit, enabled);
    close(fd);

    return PP_SUC;
}

