#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_powermanagementservice.h"

static int powermanagementservice_notsupported(pp_cim_instance_t *instance,
    vector_t *args, pp_cim_data_t *result);

// class methods
// { <name>, <result>, <num_args>, <args>, <priv>, <defptr> }
static pp_cim_method_t methods[] =
{
    {"StartService", PP_CIM_UNSIGNED, 0, NULL, 0, powermanagementservice_notsupported}, // overrides CIM_Service::StartService
    {"StopService", PP_CIM_UNSIGNED, 0, NULL, 0, powermanagementservice_notsupported}, // overrides CIM_Service::StopService
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_powermanagementservice_desc =
{
    .cim_name = "CIM_PowerManagementService",
    .ufct = "pwrmgtsvc",
    .dispname = "CIM Power Management Service",
    .superclass = "CIM_Service",
    .assoc = 0,
    .properties = NULL, // no properties
    .methods = methods,
    .update = NULL,
    .clp_update = NULL
};

// Create a new CIM_PowerManagementService instance
pp_cim_instance_t *pp_cim_powermanagementservice_new()
{
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_PowerManagementService", &provider_common);
    pp_cim_data_t d = {.null = 0, {.string_const = "IPMI Power Service"}};
    provider_common_set_property(i, "Name", d, 1);
    return i;
}

static int powermanagementservice_notsupported(pp_cim_instance_t *instance UNUSED,
    vector_t *args UNUSED, pp_cim_data_t *result)
{
    if (result) {
        result->null = 0;
        result->types.unsigned_int = 1; // not supported
    }
    return PP_SUC;
}

