#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_powersupply.h"
#include "provider_logicdev.h"

// class description
pp_cim_class_desc_t pp_cim_powersupply_desc =
{
    .cim_name = "CIM_PowerSupply",
    .ufct = "pwrsupply",
    .dispname = "CIM Power Supply",
    .superclass = "CIM_LogicalDevice",
    .assoc = 0,
    .properties = NULL, // no properties
    .methods = NULL, // no methods
    .update = NULL,
    .clp_update = NULL
};

// Create a new CIM_PowerSupply instance
pp_cim_instance_t *pp_cim_powersupply_new()
{
    pp_cim_data_t d = {0, {.string = "Power Supply"}};
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_PowerSupply", &provider_common);
    provider_common_set_property(i, "DeviceID", d, 1);
    return i;
}

