#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_system.h"

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"CreationClassName", PP_CIM_STRING_CONST, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {"Name", PP_CIM_STRING_CONST, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {.name = NULL}
};

// class methods
// { <name>, <result>, <num_args>, <args>, <priv>, <defptr> }
static pp_cim_method_t methods[] =
{
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_system_desc =
{
    .cim_name = "CIM_System",
    .ufct = NULL,
    .dispname = "CIM System",
    .superclass = NULL,
    .assoc = 0,
    .properties = properties,
    .methods = methods,
    .update = NULL,
    .clp_update = NULL
};

// Create a new CIM_System instance
pp_cim_instance_t *pp_cim_system_new()
{
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_System", &provider_common);
    return i;
}

