#ifndef _CLP_PARSER_H
#define _CLP_PARSER_H

#include <pp/clp.h>
#include <stdio.h>
#include <stdlib.h>
#include <pp/base.h>
#include <pp/vector.h>

extern const char * defaultTarget[];

typedef struct {
    pp_clp_verb_t verb_id;
    const char *verb_name;
} clp_verb_name_t;

extern clp_verb_name_t clp_verb_names[];

typedef struct {
    pp_clp_option_t option_id;
    const char *option_name;
    const char *shortcut;
} clp_option_name_t;

extern clp_option_name_t clp_option_names[];

typedef enum {
    OUT_FORMAT,
    OUT_ERROR,
    OUT_TERSE,
    OUT_VERBOSE,
    OUT_LANGUAGE,
    OUT_BEGIN,
    OUT_END,
    OUT_ORDER,
    OUT_COUNT,
    OUT_NUMBER,
    NUM_OUT_OPTIONS
} clp_output_option_t;

typedef struct {
    clp_output_option_t option_id;
    const char *option_name;
} clp_output_option_name_t;

extern clp_output_option_name_t clp_output_option_names[];

void clp_matrix_init(void);

/* check if the verb supports an option */
int pp_clp_verb_supports_option(pp_clp_verb_t verb, pp_clp_option_t option);

/* get the tokens from the input */
int clp_parser_tokenizer(pp_clp_session_t *session, char *buf, vector_t *tokens);

/* check if the syntax of the command is correct */
pp_clp_cmd_t *clp_token_check(pp_clp_session_t *session, vector_t *tokens);

/* parse a UFiP */
//int parse_ufip(const char *path, vector_t *ufip, int *relative, int *instance, int *isclass);

#endif /* _CLP_PARSER_H */
