#ifndef _PP_CLP_CLP_COMMON_H
#define _PP_CLP_CLP_COMMON_H

#include <pp/clp.h>

//#define PP_CLP_DEBUG

#if defined PP_CLP_DEBUG
#define pp_clp_debug(...) printf(__VA_ARGS__)
#else
#define pp_clp_debug(...)
#endif

pp_clp_cmd_t * pp_clp_cmd_new(void);
void pp_clp_cmd_delete(pp_clp_cmd_t *cmd);

pp_clp_option_value_t *pp_clp_optval_new(pp_clp_option_t opt);
void pp_clp_optval_delete(pp_clp_option_value_t *ov);

pp_clp_ufit_t *pp_clp_ufit_new(void);
//void pp_clp_ufit_delete(pp_clp_ufit_t *ufit);

pp_clp_target_t *pp_clp_target_new(void);
void pp_clp_target_delete(pp_clp_target_t *target);

pp_clp_property_value_t *pp_clp_propval_new(void);
void pp_clp_propval_delete(pp_clp_property_value_t *pv);

char *pp_clp_print_ufip(vector_t *ufip, int relative);

#ifdef PP_CLP_DEBUG
void pp_clp_cmd_dump(pp_clp_cmd_t * cmd);
void pp_clp_optval_dump(pp_clp_option_value_t *pv);
void pp_clp_target_dump(pp_clp_target_t *target);
void pp_clp_propval_dump(pp_clp_property_value_t *pv);
void pp_clp_output_options_dump(pp_clp_output_options_t *options);
#endif

#endif // _PP_CLP_CLP_COMMON_H

