#include "clp_common.h"
#include "clpParser.h"
#include "command.h"
#include <pp/cim.h>

int clp_verb_handler_cd(pp_clp_session_t *session, pp_clp_cmd_t *cmd)
{
	char *target;

	if (cmd->opt_help) {
		int verbose = (cmd->output.level == CLP_OUTPUT_VERBOSE);
		clp_help_verb(session->term, CLP_VERB_CD, verbose);
		return PP_SUC;
	} else if (cmd->opt_version) {
		eric_term_printf(session->term, "CD %s\r\n", VERSION);
		return PP_SUC;
	}

	if (cmd->target->type != CLP_TARGET_DEFAULT) {
		vector_t *instances = vector_new(NULL, 10, NULL);
		pp_cim_instance_t *instance = NULL;
		unsigned int i;

		instances = pp_cim_clp_lookup(cmd->target, &session->default_target);
		if (!instances) {
			eric_term_printf(session->term, "Target not found.\r\n");
			return PP_ERR;
		}
		if (vector_size(instances) == 1)
			instance = vector_get(instances, 0);
		vector_delete(instances);
		if (!instance) {
			eric_term_printf(session->term, "Target lookup failure.\r\n");
			return PP_ERR;
		}

		if (!cmd->opt_examine) {
			vector_delete(&session->default_target);
			vector_new(&session->default_target, 10,
				(vector_elem_del_func_simple)pp_clp_ufit_delete);
			pp_cim_get_ufip(instance, &session->default_target);
			free(session->prompt);
			i = vector_size(&session->default_target);
			if (i == 0) {
				session->prompt = strdup("clp:/-> ");
			} else {
				pp_clp_ufit_t *ufit = vector_get(&session->default_target, i - 1);
				int len = snprintf(NULL, 0, "clp:%s%d-> ",
					ufit->ufct, ufit->instance_id);
				session->prompt = malloc(len + 1);
				sprintf(session->prompt, "clp:%s%d-> ",
					ufit->ufct, ufit->instance_id);
			}
		}
	}

	if (cmd->opt_examine) {
		eric_term_printf(session->term, "Command validity check successful.\r\n");
		eric_term_printf(session->term, "Run without -examine option to perform command.\r\n");
	} else {
		target = pp_clp_print_ufip(&session->default_target, 0);
		eric_term_printf(session->term, "%s\r\n", target);
		free(target);
	}

	return PP_SUC;
}

