#include "clpParser.h"
#include "command.h"

int clp_verb_handler_exit(pp_clp_session_t *session, pp_clp_cmd_t *cmd)
{
	if (cmd->opt_help) {
		int verbose = (cmd->output.level == CLP_OUTPUT_VERBOSE);
		clp_help_verb(session->term, CLP_VERB_EXIT, verbose);
	} else if (cmd->opt_version) {
		eric_term_printf(session->term, "EXIT %s\r\n", VERSION);
	} else if (cmd->opt_examine) {
		eric_term_printf(session->term, "Command validity check successful.\r\n");
		eric_term_printf(session->term, "Run without -examine option to perform command.\r\n");
	} else {
		// really quit
		return PP_CLP_QUIT;
	}
	return PP_SUC;
}

