#ifndef _DISCONF_INTERN_H_
#define _DISCONF_INTERN_H_

#include "dc_common.h"

#include <openssl/bio.h>
#include <openssl/bn.h>

#include "crypto.h"


#ifdef WIN32
#define PACKED_STRUCT
#else
#define PACKED_STRUCT __attribute__ ((packed))
#endif



#define PP_DC_MAGIC_NUM 0x50504443
#define PP_DC_VERSION 1

#define PP_DC_PORT htons(456)
#define PP_DC_MC_ADDR 0xffffffff

#define STRUCT_MALLOC(s) (s*)malloc(sizeof(s))
#define HEADER_MALLOC(h,d) (h*)malloc(sizeof(h)+d)

#ifdef WIN32
#pragma pack(push,1)
#endif
typedef struct pp_dc_net_s {
    u_int32_t magic_num;
    u_int8_t version;
    pp_eui64_t src;
    pp_eui64_t dest;
    u_int8_t data[0];
} PACKED_STRUCT pp_dc_net_t;
#ifdef WIN32
#pragma pack(pop)
#endif

typedef union {
    char *raw;
    pp_dc_net_t *net;
} pp_dc_net_u;

typedef enum {
    PP_DC_COMMAND_PING=0,
    PP_DC_COMMAND_SET=1,
    PP_DC_COMMAND_GET=2,
    PP_DC_COMMAND_BIND=3,
    PP_DC_COMMAND_RELEASE=4,
    PP_DC_COMMAND_GET_PUBKEY=5,
    PP_DC_COMMAND_FW_UPDATE=6,
    PP_DC_COMMAND_CCF_CREATE=14,
    PP_DC_COMMAND_CCF_DELETE=15,
    
    PP_DC_RESPONSE_OK=32,
    PP_DC_RESPONSE_FAILED=33,
    PP_DC_RESPONSE_BOUND=34,
    PP_DC_RESPONSE_NOT_BOUND=35
} pp_dc_command_t;

#ifdef WIN32
#pragma pack(push,1)
#endif
typedef struct pp_dc_message_s {
    u_int8_t command;
    u_int32_t msg_id;  // is not processed and therefore not converted to network byte order
    u_int8_t data[0];
} PACKED_STRUCT pp_dc_message_t;
#ifdef WIN32
#pragma pack(pop)
#endif

typedef union {
    char *raw;
    pp_dc_message_t *msg;
} pp_dc_message_u;

typedef struct {
    pp_dc_net_u net;
    size_t net_size;
    pp_dc_message_u msg;
    size_t msg_size;
    pp_dc_cnode_t *cnode;
    int cstate;
} pp_dc_paket_t;


// proto.c

EXTERN_C pp_eui64_t eui64_all;

EXTERN_C int pp_dc_proto_proc(pp_dc_paket_t *in,pp_dc_paket_t *out);


// keystore.c

EXTERN_C pp_dc_privkey_t *ks_privkey;
EXTERN_C pp_dc_pubkey_t *ks_pubkey,*ks_pubkey_pemx;

EXTERN_C int pp_dc_keystore_init(void);
EXTERN_C int pp_dc_keystore_set_pemx(pp_dc_pubkey_t *pemx);


// bioutil.c

EXTERN_C int write_bn(BIO *bio,BIGNUM *bn);
EXTERN_C int read_bn(BIO *bio,BIGNUM **bn);

EXTERN_C int write_uint8(BIO* bio,u_int8_t ret);
EXTERN_C int write_uint16(BIO* bio,u_int16_t ret);
EXTERN_C int write_uint32(BIO* bio,u_int32_t ret);
EXTERN_C int write_uint64(BIO* bio,u_int64_t ret);
EXTERN_C int write_data(BIO* bio,char* data,size_t size);
EXTERN_C int write_node(BIO *bio,u_int8_t tag,char* data,u_int16_t size);

EXTERN_C int read_uint8(BIO* bio,u_int8_t *ret);
EXTERN_C int read_uint16(BIO* bio,u_int16_t *ret);
EXTERN_C int read_uint32(BIO* bio,u_int32_t *ret);
EXTERN_C int read_uint64(BIO* bio,u_int64_t *ret);
EXTERN_C int read_data(BIO* bio,char** data,size_t size);

// client.c

EXTERN_C int pp_dc_sendto(int sock,pp_eui64_t from_eui64,
	pp_eui64_t to_eui64,struct in_addr to_addr,
	pp_dc_command_t command,u_int32_t msgid,
	char * data,size_t len,
	int send_enc,pp_dc_pubkey_t * pubkey);

EXTERN_C int pp_dc_send_ping(int sock,pp_eui64_t from_eui64,
	pp_eui64_t to_eui64,struct in_addr to_addr,
	u_int32_t msgid);

EXTERN_C int pp_dc_generate_msgid(u_int32_t * msgid);

EXTERN_C int pp_dc_send_get_pubkey(int sock,pp_eui64_t from_eui64,
	pp_eui64_t to_eui64,struct in_addr to_addr,
	u_int32_t msgid);

EXTERN_C int pp_dc_send_bind(int sock,pp_eui64_t from_eui64,
	pp_eui64_t to_eui64,struct in_addr to_addr,
	u_int32_t msgid,pp_dc_pubkey_t * pubkey);

EXTERN_C int pp_dc_send_ccf_create(int sock,pp_eui64_t from_eui64,
	pp_eui64_t to_eui64,struct in_addr to_addr,
	u_int32_t msgid,char * passwd,pp_dc_pubkey_t * pubkey);

EXTERN_C int pp_dc_send_recv_ccf_create(pp_eui64_t to_eui64,
	struct in_addr to_addr,char * passwd,
	pp_dc_pubkey_t * pubkey,long timeout,char ** user);

EXTERN_C int pp_dc_send_ccf_delete(int sock,pp_eui64_t from_eui64,
	pp_eui64_t to_eui64,struct in_addr to_addr,
	u_int32_t msgid,pp_dc_pubkey_t * pubkey);

EXTERN_C int pp_dc_send_recv_ccf_delete(pp_eui64_t to_eui64,
	struct in_addr to_addr,pp_dc_pubkey_t * pubkey,long timeout);

EXTERN_C int pp_dc_get_pubkey(char * data,size_t size,pp_dc_pubkey_t ** pubkey);
    
#endif
