#include "crypto.h"
#include "disconf_intern.h"


/***************************************************************
 * ESK
 ***************************************************************/

pp_dc_esk_t*
pp_dc_esk_new()
{
    pp_dc_esk_t *ret=STRUCT_MALLOC(pp_dc_esk_t);
    ret->pub_algo=0;
    ret->size=0;
    ret->data=NULL;
    return ret;
}

pp_dc_cnode_t*
pp_dc_esk2cnode(pp_dc_esk_t *x)
{
    return pp_dc_cnode_create(PP_DC_TAG_ESK,x);
}

pp_dc_esk_t*
pp_dc_cnode2esk(pp_dc_cnode_t *x)
{
    if(x && x->tag==PP_DC_TAG_ESK)
	return x->un.esk;
    else
	return NULL;
}

void
pp_dc_esk_free(pp_dc_esk_t *esk)
{
    free(esk->data);
    free(esk);
}

int
pp_dc_esk_parse(BIO *bio,pp_dc_esk_t **esk,size_t size)
{
    *esk=pp_dc_esk_new();
    (*esk)->size=size-9;
    return read_uint8(bio,&(*esk)->pub_algo)&&
	read_uint64(bio,(u_int64_t*)&(*esk)->keyid)&&
	read_data(bio,(char**)&(*esk)->data,(*esk)->size);
}

int
pp_dc_esk_build(BIO *bio,pp_dc_esk_t *esk)
{
    return write_uint8(bio,esk->pub_algo)&&
	write_data(bio,(char*)&esk->keyid,8)&&
	write_data(bio,(char*)esk->data,esk->size);
}

pp_dc_skey_t*
pp_dc_esk2skey(pp_dc_esk_t *esk,pp_dc_privkey_t *privkey)
{
    pp_dc_skey_t *ret=NULL;
    pp_dc_cnode_t *node;
    char *data;
    size_t size;

    if(esk==NULL)
	return NULL;

    if((memcmp(&esk->keyid,&privkey->keyid,8)!=0)||
       (esk->pub_algo!=privkey->algo))
	goto bail;

    pp_dc_privkey_decrypt((char*)esk->data,esk->size,privkey,&data,&size);

    if(!pp_dc_cnode_parse_mem(data,size,&node)){
	pp_dc_cnode_free(node);
	goto bail;
    }

    ret=pp_dc_cnode2skey(node);

    free(node);

 bail:
    return ret;
}

pp_dc_esk_t*
pp_dc_skey2esk(pp_dc_skey_t *skey,pp_dc_pubkey_t *pubkey)
{
    BIO *bio=BIO_new(BIO_s_mem());
    pp_dc_cnode_t *node=pp_dc_skey2cnode(skey);
    char *data;
    size_t size;
    pp_dc_esk_t *ret=NULL;
    pp_dc_cnode_build(bio,node);
    size=BIO_get_mem_data(bio,&data);
    ret=pp_dc_esk_new();
    if(!pp_dc_pubkey_encrypt(data,size,pubkey,(char**)&ret->data,&ret->size)){
	pp_dc_esk_free(ret);
	ret=NULL;
	goto bail;
    }

    ret->keyid=pubkey->keyid;
    ret->pub_algo=pubkey->algo;

 bail:
    BIO_free(bio);
    free(node);
    return ret;
}
