#include "disconf_intern.h"

/***************************************************************
 * Privkey
 ***************************************************************/

pp_dc_privkey_t*
pp_dc_privkey_new()
{
    pp_dc_privkey_t *ret=(pp_dc_privkey_t*)malloc(sizeof(pp_dc_privkey_t));

    ret->algo=0;
    ret->key.gen=NULL;

    return ret;
}

void
pp_dc_privkey_free(pp_dc_privkey_t *privkey)
{
    switch(privkey->algo){
    case PP_DC_PUB_RSA:
	RSA_free(privkey->key.rsa);
	break;
    }
    free(privkey);
}

pp_dc_cnode_t*
pp_dc_privkey2cnode(pp_dc_privkey_t *x)
{
    return pp_dc_cnode_create(PP_DC_TAG_PRIVKEY,x);
}

pp_dc_privkey_t*
pp_dc_cnode2privkey(pp_dc_cnode_t *x)
{
    if(x->tag==PP_DC_TAG_PRIVKEY)
	return x->un.privkey;
    else
	return NULL;
}

int
pp_dc_privkey_parse(BIO *bio,pp_dc_privkey_t **privkey,size_t size)
{
    BIO *membio;
    char *data;

    *privkey=pp_dc_privkey_new();
    if(!(read_uint8(bio,&((*privkey)->algo))&&
	 read_uint64(bio,(u_int64_t*)&((*privkey)->keyid))&&
	 read_data(bio,&data,size-9))) {
	pp_dc_privkey_free(*privkey);
	*privkey=NULL;
	return 0;
    }

    membio=BIO_new_mem_buf(data,size-9);

    switch((*privkey)->algo){
    case PP_DC_PUB_RSA:
	(*privkey)->key.rsa=RSA_new();
	if(!(read_bn(membio,&(*privkey)->key.rsa->n)&&
	     read_bn(membio,&(*privkey)->key.rsa->e)&&
	     read_bn(membio,&(*privkey)->key.rsa->d)&&
	     read_bn(membio,&(*privkey)->key.rsa->p)&&
	     read_bn(membio,&(*privkey)->key.rsa->q)&&
	     read_bn(membio,&(*privkey)->key.rsa->dmp1)&&
	     read_bn(membio,&(*privkey)->key.rsa->dmq1)&&
	     read_bn(membio,&(*privkey)->key.rsa->iqmp))) {
	    RSA_free((*privkey)->key.rsa);
		BIO_free(membio);
		if(data) free(data);
	    return 0;
	}
	break;
    }
	BIO_free(membio);
	if(data) free(data);
    return 1;
}

int
pp_dc_privkey_build(BIO *bio,pp_dc_privkey_t *privkey)
{
    if(!(write_uint8(bio,privkey->algo)&&
	 write_data(bio,(char*)&privkey->keyid,8)))
	return 0;
    switch(privkey->algo){
    case PP_DC_PUB_RSA:
	if(!(write_bn(bio,privkey->key.rsa->n)&&
	     write_bn(bio,privkey->key.rsa->e)&&
	     write_bn(bio,privkey->key.rsa->d)&&
	     write_bn(bio,privkey->key.rsa->p)&&
	     write_bn(bio,privkey->key.rsa->q)&&
	     write_bn(bio,privkey->key.rsa->dmp1)&&
	     write_bn(bio,privkey->key.rsa->dmq1)&&
	     write_bn(bio,privkey->key.rsa->iqmp)))
	    return 0;
	break;
    }
    return 1;
}

pp_dc_keyid_t
pp_dc_privkey_keyid(pp_dc_privkey_t *privkey)
{
    pp_dc_pubkey_t *pubkey=pp_dc_privkey2pubkey(privkey);
    pp_dc_keyid_t ret=pp_dc_pubkey_keyid(pubkey);
    pp_dc_pubkey_free(pubkey);
    return ret;
}

pp_dc_privkey_t*
pp_dc_privkey_gen()
{
    pp_dc_privkey_t *ret = NULL;
#ifdef OLD_OPENSSL
    ret=pp_dc_privkey_new();
    ret->algo=PP_DC_PUB_RSA;
    ret->key.rsa=RSA_generate_key(1024,RSA_F4,NULL,NULL);
    ret->keyid=pp_dc_privkey_keyid(ret);
#else
    BIGNUM * bn = NULL;
    RSA * rsa = NULL;

    if ((bn = BN_new()) != NULL
	&& BN_set_word(bn, RSA_F4)
	&& (rsa = RSA_new()) != NULL
	&& RSA_generate_key_ex(rsa, 1024, bn, NULL)) {
	ret = pp_dc_privkey_new();
	ret->algo=PP_DC_PUB_RSA;
	ret->key.rsa = rsa;
	rsa = NULL;
	ret->keyid = pp_dc_privkey_keyid(ret);
    } else {
	if (rsa) RSA_free(rsa);
    }

    if (bn) BN_free(bn);
#endif
    return ret;
}

pp_dc_pubkey_t*
pp_dc_privkey2pubkey(pp_dc_privkey_t *privkey)
{
    pp_dc_pubkey_t *ret=pp_dc_pubkey_new();

    ret->algo=privkey->algo;
    ret->keyid=privkey->keyid;

    switch(privkey->algo){
    case PP_DC_PUB_RSA:
	ret->key.rsa=RSA_new();
	ret->key.rsa->n=BN_dup(privkey->key.rsa->n);
	ret->key.rsa->e=BN_dup(privkey->key.rsa->e);
	break;
    }

    return ret;
}

int
pp_dc_privkey_encrypt(char *indata,size_t insize,pp_dc_privkey_t *privkey,char **outdata,size_t *outsize)
{
    switch(privkey->algo){
    case PP_DC_PUB_RSA:
	*outdata=malloc(RSA_size(privkey->key.rsa));
	*outsize=RSA_private_encrypt(insize,(u_int8_t*)indata,(u_int8_t*)*outdata,privkey->key.rsa,RSA_PKCS1_PADDING);
	return 1;
	break;
    default:
	return 0;
    }
}

int
pp_dc_privkey_decrypt(char *indata,size_t insize,pp_dc_privkey_t *privkey,char **outdata,size_t *outsize)
{
    switch(privkey->algo){
    case PP_DC_PUB_RSA:
	*outdata=malloc(RSA_size(privkey->key.rsa));
	*outsize=RSA_private_decrypt(insize,(u_int8_t*)indata,(u_int8_t*)*outdata,privkey->key.rsa,RSA_PKCS1_PADDING);
	return 1;
	break;
    default:
	return 0;
    }
}

