/*
  atomic_write.h

  roka@peppercon.de Rolf Kampffmeyer

*/

#ifndef _PP_ATOMIC_WRITE_H
#define _PP_ATOMIC_WRITE_H

#include <sys/select.h> // definition of size_t for strstream.h
#include <pp/strstream.h>

#define PP_FA_AT_READ  0
#define PP_FA_AT_WRITE 1

// "at" stands for "atomic"
int pp_fa_at_init(void);
void pp_fa_at_cleanup(void);

/*
    pp_fa_at_open()

    parameters
    file: the file name to open
    read_or_write: either PP_FA_AT_READ or PP_FA_AT_WRITE

    return value: PP_ERR on error, a file descriptor > 0 on success
*/
int pp_fa_at_open(char * file, int read_or_write);

/*
    pp_fa_at_close()

    Until this is called, the original file doesn't change.

    parameters
    fd: a file descriptor acquired by pp_fa_at_open()

    return values
    PP_SUCC: all written data since pp_fa_at_open() was successfully written
    PP_ERR: the file is restored to the state as before pp_fa_at_open().
*/
int pp_fa_at_close(int fd);

size_t pp_fa_at_read(int fd, void * buf, int length);
size_t pp_fa_at_write(int fd, void * buf, int length);

// marks the open file to fail at close(). The content it had before pp_fa_at_open() is restored.
void pp_fa_at_fail(int fd);

int pp_fa_at_regular_file_absent(char *name);

#endif /* _PP_ATOMIC_WRITE_H */
