#ifndef _FW_ERLA_H
#define _FW_ERLA_H

#include <oem/eric_fw_oem.h>

/* include into same name space */
#define FW_MIN_DOWNGRADE_VER_STR ERIC_FW_MIN_DOWNGRADE_VER_STR
#define FW_MIN_DOWNGRADE_VER	 ERIC_FW_MIN_DOWNGRADE_VER

#define FW_HDR_VER		 3
#define FW_HDR_SIZE		 256

#define FW_PART_HDR_SIZE	 64

#define FW_PART_HDR_VER		 3
#define FW_MAGIC		 "LARA firmware "
#define FW_PART_MAGIC		 "LARA partition "

#define FW_PART_TYPE_FLASH		0
#define FW_PART_TYPE_KME		1
#define FW_PART_TYPE_KME_NEW		2
#define FW_PART_TYPE_SMARTIPC		3
#define FW_PART_TYPE_FLASH_DIR		4
#define FW_PART_TYPE_ADC_ATMEL		5
#define FW_PART_TYPE_MASTERCONSOLE	6
#define FW_PART_TYPE_MAX_II_JAM		7
#define FW_PART_TYPE_RPC_CY8_CTRL       8

#define FW_PART_TYPE_FLASH_NUM_UBOOT        3
#define FW_PART_TYPE_FLASH_NUM_UBOOT_JFFS2  1 // uboot num if jffs2 rootfs
#define FW_PART_TYPE_FLASH_DIR_NUM_OEM      0
#define FW_PART_TYPE_FLASH_DIR_NUM_ROOTFS   1
#define FW_PART_TYPE_FLASH_DIR_NUM_I18N     2

#define FW_FLASH_MAP_RAMFS       0
#define FW_FLASH_MAP_JFFS        1

#define FW_PART_TYPE_RPC_CY8_C27 0
#define FW_PART_TYPE_RPC_CY8_C26 1

/* for some unknown reason the created u-boot image is a
 * few byte too small if built for kira. */
#define FW_PART_SIZE_UBOOT_JFFS2_PPC 0x40000 /* 256 kbyte */
#define FW_PART_SIZE_UBOOT_JFFS2_ARM 0x3fff0 /* little less than 256 kbyte */
#if defined (PP_BOARD_KIRA)
#  define FW_PART_SIZE_UBOOT_JFFS2 FW_PART_SIZE_UBOOT_JFFS2_ARM
#else
#  define FW_PART_SIZE_UBOOT_JFFS2 FW_PART_SIZE_UBOOT_JFFS2_PPC
#endif /* PP_BOARD_KIRA */

/* align structure members on byte boundary */
typedef struct { /* NOTE: the character arrays are *NOT* null terminated ! */
    char magic[15];
    u_char hdr_ver;
    u_int32_t num;
    u_int32_t next_part_off;
    /* the next fields are only present since header version 3 */
    u_int32_t type;
} __attribute__ ((packed)) fw_part_hdr_t;

typedef struct { /* NOTE: the character arrays are *NOT* null terminated ! */
    u_char md5_hash[16];
    char magic[14];
    u_char hdr_ver;
    u_char ver[6];
    u_char min_req_ver[6];
    /* the next fields are only present since header version 2 */
    u_int32_t build_nr;
    char tag[64];
    char oem[16];
    char product[16];
    u_char include_hwids[16];
    u_char exclude_hwids[16];
    /* the next fields are only present since header version 3 */
    u_int16_t flash_map_sel;  /* FW_FLASH_MAP_* */
} __attribute__ ((packed)) fw_hdr_t;

int firmware_erla_init(void);

#endif /* _FW_ERLA_H */
