#include <pp/base.h>
#include <pp/firmware.h>
#include <pp/intl.h>

#include "erla.h"

static const char* pp_firmware_errors[] = {
/* 0*/ N_("An internal error occured."), // PP_FIRMWARE_ERR_INTERNAL
/* 1*/ N_("The uploaded firmware was deleted by a task with higher priority."), // PP_FIRMWARE_ERR_BAD_CONTEXT
/* 2*/ N_("Firmware size exceeded."), // PP_FIRMWARE_ERR_SIZE_EXCEEDED
/* 3*/ N_("Firmware checksum corrupted."), // PP_FIRMWARE_ERR_BAD_CRC
/* 4*/ N_("Firmware file corrupted."), // PP_FIRMWARE_ERR_CORRUPTED
/* 5*/ N_("Can't downgrade to uploaded firmware version."), // PP_FIRMWARE_ERR_NEW_VER_TOO_OLD
/* 6*/ N_("Current firmware version is too old."), // PP_FIRMWARE_ERR_CUR_VER_TOO_OLD
/* 7*/ N_("OEM version is not matching."), // PP_FIRMWARE_ERR_BAD_OEM
/* 8*/ N_("Product type is not matching."), // PP_FIRMWARE_ERR_BAD_PRODUCT
/* 9*/ N_("Hardware ID is not matching."), // PP_FIRMWARE_ERR_BAD_HWID
/*10*/ N_("No or invalid JFFS2."), // PP_FIRMWARE_ERR_BAD_JFFS2
/*11*/ N_("JFFS2 convertion not supported."), // PP_FIRMWARE_ERR_JFF2_NOT_SUPPORTED
/*12*/ N_("U-boot flash partition corrupted."), // PP_FIRMWARE_ERR_BAD_UBOOT_PART
/*13*/ N_("Unexpected flash partition found."), // PP_FIRMWARE_ERR_UNEXP_FLASH_PART
/*14*/ N_("Unexpected JFFS2 partition found."), // PP_FIRMWARE_ERR_UNEXP_JFFS_FILE
/*15*/ N_("Unexpected KME2 partition found."), // PP_FIRMWARE_ERR_UNEXP_KME2_PART
/*16*/ N_("Unexpected KME partition found."), // PP_FIRMWARE_ERR_UNEXP_KME_PART
/*17*/ N_("Failed to flash partition. Device may not work anymore if reset!"), // PP_FIRMWARE_ERR_FLASH_FLDIR_FAILED
/*18*/ N_("Failed to flash partition. Device may not work anymore if reset!"), // PP_FIRMWARE_ERR_FLASH_PART_FAILED
/*19*/ N_("Failed to flash KME partition. Keyboard/mouse may not work anymore."), // PP_FIRMWARE_ERR_FLASH_KME2_FAILED
/*20*/ N_("Failed to flash ATMEL partition. Voltage monitor may not work anymore."), // PP_FIRMWARE_ERR_FLASH_ATMEL_FAILED
/*21*/ N_("Failed to flash SMARTIPC partition. KVM switching may not work anymore."), // PP_FIRMWARE_ERR_FLASH_SMARTIPC_FAILED
/*22*/ N_("Failed to flash MASTER CONSOLE partition. Device may not work anymore if reset!"), // PP_FIRMWARE_ERR_FLASH_MASTCONIP_FAILED
/*23*/ N_("Failed to flash MAXII partition. Video redirection may not work anymore."), // PP_FIRMWARE_ERR_FLASH_MAX2_FAILED
/*24*/ N_("Failed to flash Relay board."), // PP_FIRMWARE_ERR_FLASH_CY8_FAILED
/*25*/ N_("Core system update failed. Device may not work anymore!"), // PP_FIRMWARE_ERR_CORE_UPDATE_FAILED
/*26*/ N_("Can't update OEM dirs. The device may not work correctly."), // PP_FIRMWARE_ERR_OEM_UPDATE_FAILED
/*27*/ N_("Flash directory update failed. The device may not work anymore!"), // PP_FIRMWARE_ERR_FLDIR_UPDATE_FAILED
/*28*/ N_("Flash FS partition corrupted."), // PP_FIRMWARE_ERR_BAD_FLASHFS
/*29*/ N_("Old and unsupported relay board partition found"), // PP_FIRMWARE_ERR_UNEXP_PSOC_PART
};

static int initialized = 0;

// remember and access errno-base of this module
static int errno_base = 0; 
int pp_firmware_errno_base(void) { assert(errno_base > 0); return errno_base; }

// return error string for module errno
static const char* get_error_string(const int error) {
    return pp_firmware_errors[error - errno_base];
}

int
pp_firmware_init(void)
{
    if (!initialized) {
	if (firmware_erla_init() == -1) return -1;
	initialized = 1;

	// obtain errno_base from errno-registry 
	//     and register string conversion function
	errno_base = pp_register_errnos(sizeof(pp_firmware_errors) /
					sizeof(*pp_firmware_errors),
					get_error_string);
    }
    return 0;
}

void
pp_firmware_cleanup(void)
{
    pp_unregister_errnos(errno_base);
    initialized = 0;
}
