#ifndef __PP_FIRMWARE_H
#define __PP_FIRMWARE_H

#include <liberic_session.h>

#define PP_FIRMWARE_ERLA_MAX_SIZE	(7*1024*1024)
/* firmware version string sizes
 * Attention: 'mkfirmware' relies on fixed offsets of firmware
 * strings. Changing these size constants might corrupt the mkfirmware
 * mechanisms. Please check/adjust mkfirmware scripts before editing
 * these defines
 */
#define PP_FIRMWARE_ERLA_VERSION_LEN	6
#define PP_FIRMWARE_ERLA_BUILD_NR_LEN	5
#define PP_FIRMWARE_ERLA_TAG_LEN	64

#define PP_FIRMWARE_ERR_NONCRIT         -1
#define PP_FIRMWARE_ERR_CRIT            -2

#define PP_FIRMWARE_ERR_NO_ERROR                0
#define PP_FIRMWARE_ERR_INTERNAL                (pp_firmware_errno_base() + 0)
#define PP_FIRMWARE_ERR_BAD_CONTEXT             (pp_firmware_errno_base() + 1)
#define PP_FIRMWARE_ERR_SIZE_EXCEEDED           (pp_firmware_errno_base() + 2)
#define PP_FIRMWARE_ERR_BAD_CRC                 (pp_firmware_errno_base() + 3)
#define PP_FIRMWARE_ERR_CORRUPTED               (pp_firmware_errno_base() + 4)
#define PP_FIRMWARE_ERR_NEW_VER_TOO_OLD         (pp_firmware_errno_base() + 5)
#define PP_FIRMWARE_ERR_CUR_VER_TOO_OLD         (pp_firmware_errno_base() + 6)
#define PP_FIRMWARE_ERR_BAD_OEM                 (pp_firmware_errno_base() + 7)
#define PP_FIRMWARE_ERR_BAD_PRODUCT             (pp_firmware_errno_base() + 8)
#define PP_FIRMWARE_ERR_BAD_HWID                (pp_firmware_errno_base() + 9)
#define PP_FIRMWARE_ERR_BAD_JFFS2               (pp_firmware_errno_base() + 10)
#define PP_FIRMWARE_ERR_JFFS2_NOT_SUPPORTED     (pp_firmware_errno_base() + 11)
#define PP_FIRMWARE_ERR_BAD_UBOOT_PART          (pp_firmware_errno_base() + 12)
#define PP_FIRMWARE_ERR_UNEXP_FLASH_PART        (pp_firmware_errno_base() + 13)
#define PP_FIRMWARE_ERR_UNEXP_JFFS_PART         (pp_firmware_errno_base() + 14)
#define PP_FIRMWARE_ERR_UNEXP_KME2_PART         (pp_firmware_errno_base() + 15)
#define PP_FIRMWARE_ERR_UNEXP_KME_PART          (pp_firmware_errno_base() + 16)
#define PP_FIRMWARE_ERR_FLASH_FLDIR_FAILED      (pp_firmware_errno_base() + 17)
#define PP_FIRMWARE_ERR_FLASH_PART_FAILED       (pp_firmware_errno_base() + 18)
#define PP_FIRMWARE_ERR_FLASH_KME2_FAILED       (pp_firmware_errno_base() + 19)
#define PP_FIRMWARE_ERR_FLASH_ATMEL_FAILED      (pp_firmware_errno_base() + 20)
#define PP_FIRMWARE_ERR_FLASH_SMARTIPC_FAILED   (pp_firmware_errno_base() + 21)
#define PP_FIRMWARE_ERR_FLASH_MASTCONIP_FAILED  (pp_firmware_errno_base() + 22)
#define PP_FIRMWARE_ERR_FLASH_MAX2_FAILED       (pp_firmware_errno_base() + 23)
#define PP_FIRMWARE_ERR_FLASH_CY8_FAILED        (pp_firmware_errno_base() + 24)
#define PP_FIRMWARE_ERR_CORE_UPDATE_FAILED      (pp_firmware_errno_base() + 25)
#define PP_FIRMWARE_ERR_OEM_UPDATE_FAILED       (pp_firmware_errno_base() + 26)
#define PP_FIRMWARE_ERR_FLDIR_UPDATE_FAILED     (pp_firmware_errno_base() + 27)
#define PP_FIRMWARE_ERR_BAD_FLASHFS             (pp_firmware_errno_base() + 28)
#define PP_FIRMWARE_ERR_UNEXP_RPC_PART          (pp_firmware_errno_base() + 29)

/* firmware update context */
typedef unsigned int pp_firmware_ctx_t;

/* global firmware variables */
extern char* pp_firmware_erla_version;      //[PP_FIRMWARE_ERLA_VERSION_LEN+1]
extern u_char pp_firmware_erla_version_major;
extern u_char pp_firmware_erla_version_minor;
extern u_char pp_firmware_erla_version_subminor;
extern char* pp_firmware_erla_build_nr_str; //[PP_FIRMWARE_ERLA_BUILD_NR_LEN+1]
extern u_int pp_firmware_erla_build_nr;
extern char* pp_firmware_erla_tag;          //[PP_FIRMWARE_ERLA_TAG_LEN+1]

int pp_firmware_init(void);
void pp_firmware_cleanup(void);
int pp_firmware_errno_base(void);

pp_firmware_ctx_t pp_firmware_erla_ctx_new(size_t data_len, int preempt);
void pp_firmware_erla_ctx_free(pp_firmware_ctx_t ctx);
int pp_firmware_erla_data_set_len(pp_firmware_ctx_t ctx, size_t data_len);
ssize_t pp_firmware_erla_data_get_len(pp_firmware_ctx_t ctx);
int pp_firmware_erla_data_set(pp_firmware_ctx_t ctx, const void * data, size_t offset, size_t data_len);
int pp_firmware_erla_data_get(pp_firmware_ctx_t ctx, void * data, size_t offset, size_t data_len);
int pp_firmware_erla_get_md5_hash(pp_firmware_ctx_t ctx, u_char * hash);
int pp_firmware_erla_test_and_set_update_lock_no_ctx(void);
int pp_firmware_erla_is_update_locked_no_ctx(void);
int pp_firmware_erla_test_and_set_update_lock(pp_firmware_ctx_t ctx);
int pp_firmware_erla_release_update_lock_no_ctx(void);
int pp_firmware_erla_release_update_lock(pp_firmware_ctx_t ctx);
int pp_firmware_erla_get_info(pp_firmware_ctx_t ctx, char** ver, u_int* buildnr,
			      char** tag, char** min_req_ver, char** min_dwngrd_ver);
int pp_firmware_erla_validate(pp_firmware_ctx_t ctx, int cross_oem, int cross_hwid);
int pp_firmware_erla_update(pp_firmware_ctx_t ctx);
int pp_firmware_erla_reset_device(eric_session_int_id_t session);

#endif // __PP_FIRMWARE_H
