#ifndef _DEBUG_H
#define _DEBUG_H

#include <pp/base.h>
#include <lara.h>

/*********************************************************************
 * libpp_grab: debug.h
 *
 * This file contains defines for debugging
 *
 ********************************************************************/

#define D_SILENT	0
#define D_ALWAYS	1
#define D_ERROR		2
#define D_NOTICE	3
#define D_VERBOSE	4
#define D_BLABLA	5

#ifndef DEBUGLEVEL
# define DEBUGLEVEL D_ERROR
#endif

#define DCH(x, fmt, args...)  { \
    if (x <= DEBUGLEVEL) { \
	pp_log("GRAB%d: ",  video_link); \
	printf(fmt, ##args); \
    } \
} 

#define D(x, fmt, args...) { if (x <= DEBUGLEVEL) { pp_log("GRABx: "); printf(fmt, ##args); } }

#define noDEBUG_DIFFMAP
#define noDEBUG_DUMP_REGION
#define noDEBUG_CHECK_REGION


void dbg_dump_reg(u_char *buf, u_long size, RegionRec *reg, vsc_encoding_desc_t enc, fb_color_info_t *fb_c_info, u_char video_link);
int  dbg_check_reg(RegionRec *reg, vsc_encoding_desc_t enc, fb_color_info_t *fb_c_info, u_char video_link);

#if defined(DEBUG_DIFFMAP)
void print_buffer(u_char *buf, int size, int brk);
#endif

int decodeRLEFrame(char* buf, int size, int w, int h, uint32_t enc);

#define FIX_MEM_DESC_DEBUG1_SIZE	(1024 * 1024)
#define FIX_MEM_DESC_DEBUG2_SIZE	(1024 * 1024)


/* profiling functions */

#define noDEBUG_PROFILE
#define PROFILE_PRINT_COUNT		10

#ifdef DEBUG_PROFILE

#define MAX_NO_PROFILERS                16

#define PROFILE_FETCH_DIFFMAP           0
#define PROFILE_FETCH_TILES		1
#define PROFILE_SPLIT_REGION		2
#define PROFILE_CALC_DIFFMAP		3
#define PROFILE_CALC_DIFFMAP_REGIONS	4
#define PROFILE_TRANSFER_ALL		5
#define PROFILE_MISC			6

extern void profiler_init(void);
extern void profiler_add(unsigned int id, char *name);
extern void profiler_reset(unsigned int id);
extern void profiler_reset_all();
extern void profiler_start(unsigned int id);
extern void profiler_done(unsigned int id);
extern void profiler_print(int dbg_level, unsigned int id);
extern void profiler_print_all(int dbg_level);

#else /* !DEBUG_PROFILE */

#define profiler_init()         ((void)0)
#define profiler_add(id, name)  ((void)0)
#define profiler_reset(id)      ((void)0)
#define profiler_reset_all()    ((void)0)
#define profiler_start(id)      ((void)0)
#define profiler_done(id)       ((void)0)
#define profiler_print(d, id)   ((void)0)
#define profiler_print_all(d)   ((void)0)

#endif /* !DEBUG_PROFILE */

#endif /* _DEBUG_H */
