/* system includes */

/* firmware includes */
#include <pp/base.h>
#include <pp/hal.h>
#include <pp/hal_common.h>

/* local includes */
#include "kx2/kx2.h"
#include "icpmmd/icpmmd.h"
#ifdef PRODUCT_PDU
#include "rpc/rpc.h"
#endif

static int initialized = 0;

int
pp_hal_init(void)
{
    if (!initialized) {
#ifdef PP_FEAT_CREATE_FLASHID
        if (pp_hal_common_create_flash_id() != 0) {
            pp_log_err("Flash ID creation failed\n");
        }
#endif
#ifdef PRODUCT_ICPMMD
	icpmmd_init();
#endif
#ifdef PRODUCT_KX2
	pcf8574_init();
#endif
#ifdef PRODUCT_PDU
        /* TODO: check for error here? */
        rpc_init();
#endif
        initialized = 1;
    }
    return 0;
}

void
pp_hal_cleanup(void)
{
#ifdef PRODUCT_ICPMMD
    icpmmd_cleanup();
#endif
#ifdef PRODUCT_KX2
    power_supply_monitor_thread_clean();
    pcf8574_cleanup();
#endif
    initialized = 0;
}

