#include <pp/base.h>
#include <pp_gpio.h>
#include <pp/hal_kx2.h>
#include <gpio_hilevel_functions.h>

static pthread_t g_buzzer_thread=0;

//! Forward declaration 
void * beep(void *duration);
void pp_hal_kx2_buzzer(int on);

void
pp_hal_kx2_buzzer(int on) {
    pp_gpio_bit_set(PP_GPIO_DEV_IBM, PP_GPIO_BUZZER, (on?1:0));
}

void * beep(void *duration) {    
    pp_hal_kx2_buzzer(1);
    sleep( (long) duration);
    pp_hal_kx2_buzzer(0); 
    return NULL;
}

int pp_hal_kx2_beep(unsigned int duration) {
    int nRet = 0;
    nRet = pthread_create( &g_buzzer_thread, NULL, beep, (void *)(long)duration);      
    if ( nRet == 0 ) {
        nRet = pthread_detach(g_buzzer_thread);
        if ( nRet != 0 )
	perror("buzzer thread: pthread detach error:");

    } else {
        printf("buzzer thread : create failed \n");
    }
    return nRet;
}
