#include <string.h>
#include <assert.h>
#include <pp/hal_common.h>
#include <pp/features.h>
#include "kx2.h"

/* FIXME: issue with little/big endian stuff, unify kx2 defines with u-boot */

int pp_hal_common_get_vsc_cnt(void) {
    int vsc_cnt = 0;

    unsigned char hwid = pp_hal_common_get_hardware_id();

    switch ((hwid & RARITAN_HWID_MODEL_MASK) >> RARITAN_HWID_MODEL_SHIFT) {
	case RARITAN_HWID_MODEL_KX432: /* fall through */
	case RARITAN_HWID_MODEL_KX416: /* fall through */
	case RARITAN_HWID_MODEL_KX464:
	    vsc_cnt = 4;
	    break;
	case RARITAN_HWID_MODEL_KX232: /* fall through */
	case RARITAN_HWID_MODEL_KX216:
	    vsc_cnt = 2;
	    break;
	case RARITAN_HWID_MODEL_KX132: /* fall through */
	case RARITAN_HWID_MODEL_KX116:
	    vsc_cnt = 1;
	    break;
	default:
	    assert(0);
		}
//FIXME: (Bozana) either HW is not working or formula to obtain vsc count
//So, since we are working with 4XX models only, hard-code value to 4.
//Must be fixed before merging to the main!!!!
    vsc_cnt = 4;

    return vsc_cnt;
}


int pp_hal_common_get_target_port_cnt(void) {
    int num_targets = 0;

    unsigned char hwid = pp_hal_common_get_hardware_id();

    switch ((hwid & RARITAN_HWID_MODEL_MASK) >> RARITAN_HWID_MODEL_SHIFT) {
        case RARITAN_HWID_MODEL_KX464:
	    num_targets = 64;
	    break;
        case RARITAN_HWID_MODEL_KX432: /* fall through */
        case RARITAN_HWID_MODEL_KX232: /* fall through */
        case RARITAN_HWID_MODEL_KX132: /* fall through */
	    num_targets = 32;
	    break;
        case RARITAN_HWID_MODEL_KX416: /* fall through */
        case RARITAN_HWID_MODEL_KX216:
        case RARITAN_HWID_MODEL_KX116:
            num_targets = 1;
            break;
	default:
	    assert(0);
    }

//FIXME: (Bozana) either HW is not working or formula to obtain vsc count
//So, since we are working with 4XX models only, hard-code value to 16.
//Fix that before merging to the main!!!!
    num_targets = 16;

    return num_targets;
}
