/**
 * \file ipmi_oem_intel.h
 *
 * Description: OEM commands for Intel ESB2-BMC
 *
 * (c) 2005 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#include <pp/ipmi.h>

#ifndef IPMI_OEM_INTEL_H
#define IPMI_OEM_INTEL_H

#define IPMI_NETFN_OEM_INTEL_USR_CFG    0x30

#define BMC_OEM_INTEL_GET_USR_CFG       0xb0
#define BMC_OEM_INTEL_SET_USR_CFG       0xb1

#define ESB2_BMC_VER 26

#if ESB2_BMC_VER <= 5

#define IPMI_NETFN_OEM_INTEL_TPT        0x38

#define BMC_OEM_INTEL_GET_TPT_STATUS    0x01
#define BMC_OEM_INTEL_TPT_LISTEN        0x02
#define BMC_OEM_INTEL_GET_TPT_CFG       0x03
#define BMC_OEM_INTEL_SET_TPT_CFG       0x04

#else

#define IPMI_NETFN_OEM_INTEL_TPT        0x34

#define BMC_OEM_INTEL_GET_TPT_STATUS    0x10
#define BMC_OEM_INTEL_TPT_LISTEN        0x11
#define BMC_OEM_INTEL_GET_TPT_CFG       0x12
#define BMC_OEM_INTEL_SET_TPT_CFG       0x13

#endif

int ipmi_oem_intel_usr_cfg_main(struct ipmi_intf *, int, pp_ipmi_parameter_t *, pp_ipmi_return_t *ret, int * error);
int ipmi_oem_intel_tpt_main(struct ipmi_intf *, int, pp_ipmi_parameter_t *, pp_ipmi_return_t *ret, int * error);

#endif /* !IPMI_OEM_INTEL_H */
