/**
 * \file ipmi_oem_pp_rpc.h
 *
 * Description: OEM commands for KIRA RPC boards
 *
 * (c) 2006 Peppercon AG
 *                        
 */

#ifndef IPMI_OEM_PP_RPC_H
#define IPMI_OEM_PP_RPC_H

#include <pp/ipmi.h>

#define IPMI_NETFN_OEM_PP		0x3C
/*
 * Peppercon RPC OEM commands
 */
#define IPMI_CMD_PP_RPC_SET_POWER_ON_DELAY          0x10
#define IPMI_CMD_PP_RPC_GET_POWER_ON_DELAY          0x11
#define IPMI_CMD_PP_RPC_SET_RECEPTACLE_STATE        0x12
#define IPMI_CMD_PP_RPC_GET_RECEPTACLE_STATE        0x13
#define IPMI_CMD_PP_RPC_SET_GROUP_STATE             0x14
#define IPMI_CMD_PP_RPC_SET_GROUP_MEMBERSHIP        0x15
#define IPMI_CMD_PP_RPC_GET_GROUP_MEMBERSHIP        0x16
#define IPMI_CMD_PP_RPC_SET_GROUP_POWER_ON_DELAY    0x17
#define IPMI_CMD_PP_RPC_GET_GROUP_POWER_ON_DELAY    0x18
#define IPMI_CMD_PP_RPC_SET_RECEPTACLE_ACL          0x19
#define IPMI_CMD_PP_RPC_GET_RECEPTACLE_ACL          0x1a

int ipmi_oem_pp_rpc_main(struct ipmi_intf *, int, pp_ipmi_parameter_t *, pp_ipmi_return_t *ret, int * error);

#endif /* !IPMI_OEM_PP_RPC_H */

