/*
 * Copyright (c) 2006 Raritan, All Rights Reserved.
 * Author: Ralf Guenther ralf.guenther@raritan.com
 */

#ifndef IPMI_RARITANOEM_H
#define IPMI_RARITANOEM_H

#include <pp/ipmi.h>
#include <ipmitool/ipmi.h>

#define IPMI_NETFN_RARITANOEM                       0x3c

// Firmware Upgrade
#define IPMI_RARITANOEM_GET_FIRMWARE_VERSION        0x20
#define IPMI_RARITANOEM_START_FIRMWARE_UPGRADE      0x21
#define IPMI_RARITANOEM_UPLOAD_FIRMWARE             0x22
#define IPMI_RARITANOEM_FLASH_FIRMWARE              0x23
#define IPMI_RARITANOEM_CANCEL_FIRMWARE_UPGRADE     0x24
#define IPMI_RARITANOEM_FINALIZE_FIRMWARE_UPGRADE   0x25

// Self-Test
#define IPMI_RARITANOEM_PERFORM_SELFTEST            0x28
#define IPMI_RARITANOEM_SELFTEST_RESULT             0x29

// Config System
#define IPMI_RARITANOEM_CONFIG_GET                  0x30
#define IPMI_RARITANOEM_CONFIG_SET                  0x31
#define IPMI_RARITANOEM_START_CONFIG_BACKUP         0x32
#define IPMI_RARITANOEM_BACKUP_CONFIG               0x33
#define IPMI_RARITANOEM_FINISH_CONFIG_BACKUP        0x34
#define IPMI_RARITANOEM_START_CONFIG_RESTORE        0x35
#define IPMI_RARITANOEM_RESTORE_CONFIG              0x36
#define IPMI_RARITANOEM_FINISH_CONFIG_RESTORE       0x37

// Miscellaneous
#define IPMI_RARITANOEM_RESET_TO_FACTORY_DEFAULTS   0x40
#define IPMI_RARITANOEM_GET_SERIAL_NUMBER           0x41
#define IPMI_RARITANOEM_SET_SERIAL_NUMBER           0x42

// (User) management
#define IPMI_CMD_PP_SET_EXTENDED_USER_PARAMETERS    0x48
#define IPMI_CMD_PP_GET_EXTENDED_USER_PARAMETERS    0x49

// Remote Mass Storage
#define IPMI_RARITANOEM_GET_VMEDIA_STATUS           0x50
#define IPMI_RARITANOEM_CLOSE_VMEDIA_SESSION        0x51
#define IPMI_RARITANOEM_START_FLOPPY_IMG_UPLOAD     0x52
#define IPMI_RARITANOEM_UPLOAD_FLOPPY_IMG           0x53
#define IPMI_RARITANOEM_FINALIZE_FLOPPY_IMG_UPLOAD  0x54
#define IPMI_RARITANOEM_START_SMB_IMG_MOUNT         0x55
#define IPMI_RARITANOEM_SET_SMB_IMG_PARAM           0x56
#define IPMI_RARITANOEM_FINALIZE_SMB_IMG_MOUNT      0x57


// parameters for set/get extended user data */
#define IPMI_OEM_PP_EXT_USER_DEVICE_UID		    0x01

int ipmi_raritanoem_main(struct ipmi_intf * intf, int subcommand,
			 pp_ipmi_parameter_t *params, pp_ipmi_return_t *ipmi_ret,
			 int * error);

#endif /*IPMI_RARITANOEM_H*/

