#ifndef __IPMI_RETURN_H
#define __IPMI_RETURN_H

#include <pp/ipmi.h>
#ifndef _WIN32
#include <inttypes.h>
#endif

/* helper functions */
void ipmi_set_timestamp(time_t timestamp, pp_ipmi_time_t *pp_time);

/* allocate the return structures according to the requested
   ipmi operation */

int ipmi_init_chassis_status(pp_ipmi_return_t* ret);
int ipmi_init_chassis_power_status(pp_ipmi_return_t* ret);
int ipmi_init_bmc_info(pp_ipmi_return_t* ret);
int ipmi_init_bmc_get_enables(pp_ipmi_return_t* ret);
int ipmi_init_bmc_get_device_guid(pp_ipmi_return_t* ret);
int ipmi_init_bmc_get_system_guid(pp_ipmi_return_t* ret);
int ipmi_init_bmc_get_acpi_state(pp_ipmi_return_t* ret);
int ipmi_init_chassis_poh(pp_ipmi_return_t* ret);
int ipmi_init_chassis_restart_cause(pp_ipmi_return_t* ret);
int ipmi_init_chassis_get_bootparam(pp_ipmi_return_t* ret);
int ipmi_init_chassis_get_bootflag(pp_ipmi_return_t* ret);
int ipmi_init_sel_info(pp_ipmi_return_t* ret);
int ipmi_init_sel_get_time(pp_ipmi_return_t* ret);
int ipmi_init_sel_list(pp_ipmi_return_t* ret);
pp_ipmi_sel_list_entry_t * ipmi_init_sel_list_entry(pp_ipmi_return_t* ret);
int ipmi_init_fru_info(pp_ipmi_return_t* ret);
int ipmi_init_sdr_info(pp_ipmi_return_t* ret);
int ipmi_init_sdr_list(pp_ipmi_return_t* ret);
pp_ipmi_sdr_list_entry_t * ipmi_init_sdr_list_entry(pp_ipmi_sensor_type_t type, pp_ipmi_return_t* ret);
int ipmi_init_sensor_list(pp_ipmi_return_t* ret);
int ipmi_init_sensor_get_list(pp_ipmi_return_t* ret);
int ipmi_init_sensor_get_raw_list(pp_ipmi_return_t* ret);
int ipmi_init_sensor_get_thresh_list(pp_ipmi_return_t* ret);
pp_ipmi_sdr_list_entry_t * ipmi_init_sensor_get_list_entry(pp_ipmi_sensor_type_t type, pp_ipmi_return_t* ret);
pp_ipmi_raw_reading_list_entry_t*
   ipmi_init_sensor_get_raw_list_entry(int sensor_num, pp_ipmi_return_t* ret);
pp_ipmi_raw_thresholds_list_entry_t*
   ipmi_init_sensor_get_thresholds_list_entry(int sensor_num,
                                              pp_ipmi_return_t* ret);
int ipmi_init_lanp_get(pp_ipmi_return_t* ret);
int ipmi_init_lanp_dest_list(pp_ipmi_return_t* ret);
pp_ipmi_lanp_dest_list_entry_t * ipmi_init_lanp_dest_list_entry(uint8_t id, pp_ipmi_return_t* ret);
int ipmi_init_pef_filter_list(pp_ipmi_return_t* ret);
pp_ipmi_pef_filter_t* ipmi_init_pef_filter_list_entry(pp_ipmi_return_t* ret);
int ipmi_init_pef_policy_list(pp_ipmi_return_t* ret);
pp_ipmi_pef_policy_t* ipmi_init_pef_policy_list_entry(pp_ipmi_return_t* ret);
int ipmi_init_lan_destination_list(pp_ipmi_return_t* ret);
pp_ipmi_lanp_dest_t* ipmi_init_lan_destination_list_entry(pp_ipmi_return_t* ret);
int ipmi_init_oem_raritan_fw_version(pp_ipmi_return_t* ret);
int ipmi_init_oem_raritan_sn(pp_ipmi_return_t* ret);
int ipmi_init_raw_data(pp_ipmi_return_t* ret);

#ifdef OEM_RACKABLE
int ipmi_init_oem_rackable_get_slot(pp_ipmi_return_t* ret);
int ipmi_init_oem_rackable_get_state(pp_ipmi_return_t* ret);
#endif

#endif /* __IPMI_RETURN_H */
