/*
 * Copyright (c) 2006 Raritan Computer Inc.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * Redistribution of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * Redistribution in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any kind.
 * ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES,
 * INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED.
 * SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.  IN NO EVENT WILL
 * SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA,
 * OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
 * PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
 * LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE,
 * EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * You acknowledge that this software is not designed or intended for use
 * in the design, construction, operation or maintenance of any nuclear
 * facility.
 */

#ifndef _SCSI_API_H
#define _SCSI_API_H

typedef struct scsi_drive_s {
    char *path; /* e.g. "/dev/sg0" or "C:" */
    char *name; /* e.g. "Virtual Disc 1" */
} scsi_drive_t;

/* Find all available virtual USB drives; element type: scsi_drive_t */
scsi_drive_t *scsi_scan_devices(const char *product);

void scsi_free_device_list(scsi_drive_t *list);


/* Opaque structure, system-dependent */
typedef struct scsi_dev_s scsi_dev_t;

typedef enum {
    SCSI_DATADIR_NONE,
    SCSI_DATADIR_FROM_DEVICE,
    SCSI_DATADIR_TO_DEVICE
} scsi_datadir_t;

typedef struct scsi_ioreq_s {
    unsigned char *cmd_buf;   /* SCSI command buffer */
    int cmd_len;              /* length of SCSI command */
    int timeout;              /* command timeout in milliseconds */
    scsi_datadir_t datadir;   /* direction of data phase */
    unsigned char *data_buf;  /* data transfer buffer */
    int data_len;             /* maximum data byte count */
    unsigned char status;     /* command result */
    int actual_len;           /* actually transferred byte count */
} scsi_ioreq_t;

/* Open SCSI device */
scsi_dev_t *scsi_open(const char *path);

/* Close SCSI device */
void scsi_close(scsi_dev_t *dev);

/* Perform a SCSI command */
int scsi_send_request(scsi_dev_t *dev, scsi_ioreq_t *cmd);

#endif
