#include "liberic_misc.h"
#include "driver.h"
#include "data_kbd.h"
#include <pp/kvm.h>
#if PP_FEAT_KBD_BREAK_TIMEOUT
#include <pp/timerq.h>
#endif /* PP_FEAT_KBD_BREAK_TIMEOUT */

#define KEY_EVENT_PRESSED	1
#define KEY_EVENT_RELEASED	2


/* state of whole keyboard (per KVM port) */
typedef struct keyboard_pstate_s {
    uint8_t keys[MAX_KEYDEFS];
} keyboard_pstate_t;

typedef struct {
    pp_propchange_listener_t propchange_listener;
    driver_t* obj;
} data_conv_kbd_propchange_listener_t;

typedef struct {
    /* protects access to obj struct */
    pthread_mutex_t kbd_data_mtx;

    /* array of pointers, one for each kvm unit
     *     - a ptr is NULL if no mem is allocated
     *     - each ptr points to an array, indexed by kvm port, holding
     *       a keyboard_pstate_t for each port */
    keyboard_pstate_t *keyboard_pstate_list_units [PP_KVM_MAX_UNIT_COUNT];

    /* listens e.g. for kvm unit add/remove events */
    data_conv_kbd_propchange_listener_t propchange_listener;

    int update_before;
    int bulk_keys;
#if PP_FEAT_KBD_BREAK_TIMEOUT
    int             timeout_enabled;
    unsigned int    timeout;
    int             control_sequence;
    pp_timerq_t*    timerq[PP_KVM_MAX_UNIT_COUNT][PP_KVM_MAX_UNIT_PORT_COUNT];
#endif /* PP_FEAT_KBD_BREAK_TIMEOUT */
} kbd_data_t;

