/* layer   : data unit
   pdu type: relative USB HID mouse report
*/

/* system includes */
#include <stdlib.h>
#include <sys/types.h>
#include <stdio.h>

/* firmware includes */
#include <pp/base.h>

/* local includes */
#include "driver.h"
#include "data_unit_mouse_rusb.h"
#include "data_unit_mouse_usb.h"


static int send_mouse_data(driver_t* obj, const int16_t x, const int16_t y, const int16_t z, const u_int8_t button);
static int cleanup(driver_t* obj);
static int reconfigure(driver_t* obj);
static int resume(driver_t* obj);
static int suspend(driver_t* obj);
static int is_equal(driver_t* obj, driver_t* d);   

int init_data_unit_mouse_rusb(driver_t* obj) {
    assert(obj);
    
    obj->data_unit_mouse.id = __FUNCTION__;
    obj->data_unit_mouse.is_equal = is_equal;
    obj->data_unit_mouse.resume = resume;
    obj->data_unit_mouse.suspend = suspend;
    obj->data_unit_mouse.cleanup = cleanup;
    obj->data_unit_mouse.reconfigure = reconfigure;
    obj->data_unit_mouse.send_mouse_data = send_mouse_data;
    
    return 0;
}

static int cleanup(driver_t * /* obj */) {
    return 0;
}

static int resume(driver_t * /* obj */) {
    return 0;
}

static int suspend(driver_t * /* obj */) {
    return 0;
}

static int is_equal(driver_t* obj, driver_t* d) {
    assert(obj);
    assert(d);
    
    if (!strcmp(obj->data_unit_mouse.id, d->data_unit_mouse.id)) {
	return 1;
    } else {
	return 0;
    }
}

static int reconfigure(driver_t * /* obj */) {
    return 0;
}

static int send_mouse_data(driver_t* obj, const int16_t x, const int16_t y, const int16_t z, const u_int8_t buttons) {
    mouse_report_a_t mouse_report;

    assert(obj);
    KD("DEBUG: got coordinates: (%d/%d/%d), buttons: %x\n", x,y,z,buttons);
    
    mouse_report.buttonmask = (unsigned char)0;
    if (buttons & BUTTON_LEFT_MASK) mouse_report.buttonmask |= USB_BUTTON_1;
    if (buttons & BUTTON_RIGHT_MASK) mouse_report.buttonmask |= USB_BUTTON_2;
    if (buttons & BUTTON_MIDDLE_MASK) mouse_report.buttonmask |= USB_BUTTON_3;
    
    if ( (x < -127) || (x > 127) ||
	 (y < -127) || (y > 127) ||
	 (z < -127) || (z > 127) ) {
	printf("x,y or z values out of bounds (-127 <= x <= 127) : x=%d, y=%d, z=%d\n", x,y,z);	
	return -1;
    }

    mouse_report.x = (uint8_t)x;
    mouse_report.y = -(uint8_t)y;
    mouse_report.w = -(uint8_t)z;
    
    return obj->comm_proto.send_pdu(obj, (char*)&mouse_report, sizeof(mouse_report), PP_KM_INPUT_MOUSE);
}
