/*****************************************************************************
* iipptr_cursor.h                                                            *
*                                                                            *
* Copyright 2002 Peppercon AG                                                *
* Author: Thomas Rendelmann                                                  *
*                                                                            *
* Part of libpp_km                                                           *
* mouse driver iipps2 for Intelligent Mouse cursor Tracking                  *
*                                                                            *
* Contains some operations on the mouse cursor                               *
*****************************************************************************/

#ifndef __IIPPTR_CURSOR_H

#define __IIPPTR_CURSOR_H

#include "iipptr_help.h"
#include "driver.h"

/* obj function tries to find the mouse cursor on the screen in a
   stripe at the top of the screen for building the acceleration table*/
int find_cursor_for_table(driver_t* obj, t_point *center, t_point *found);

/* obj takes a screenshot of the current mouse cursor
   therefore the mouse is moved into the upper left corner */
int get_mousecursor_shape(driver_t* obj);

/* obj takes two screenshot-bitmaps (one for the background and one hopefully
   including the cursor) and creates a difference mask, useful for remove_empty_rows */
int diff_mousecursor_shape(t_bitmap *cursor, t_bitmap *background, t_bitmap *mask);


#endif /* __IIPPTR_CURSOR_H */
